// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDatabaseBackupProperties : IUtf8JsonSerializable, IJsonModel<AutonomousDatabaseBackupProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDatabaseBackupProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDatabaseBackupProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBackupProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseBackupProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(AutonomousDatabaseOcid))
            {
                writer.WritePropertyName("autonomousDatabaseOcid"u8);
                writer.WriteStringValue(AutonomousDatabaseOcid);
            }
            if (options.Format != "W" && Optional.IsDefined(DatabaseSizeInTbs))
            {
                writer.WritePropertyName("databaseSizeInTbs"u8);
                writer.WriteNumberValue(DatabaseSizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DBVersion))
            {
                writer.WritePropertyName("dbVersion"u8);
                writer.WriteStringValue(DBVersion);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(Ocid))
            {
                writer.WritePropertyName("ocid"u8);
                writer.WriteStringValue(Ocid);
            }
            if (options.Format != "W" && Optional.IsDefined(IsAutomatic))
            {
                writer.WritePropertyName("isAutomatic"u8);
                writer.WriteBooleanValue(IsAutomatic.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsRestorable))
            {
                writer.WritePropertyName("isRestorable"u8);
                writer.WriteBooleanValue(IsRestorable.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleDetails))
            {
                writer.WritePropertyName("lifecycleDetails"u8);
                writer.WriteStringValue(LifecycleDetails);
            }
            if (options.Format != "W" && Optional.IsDefined(LifecycleState))
            {
                writer.WritePropertyName("lifecycleState"u8);
                writer.WriteStringValue(LifecycleState.Value.ToString());
            }
            if (Optional.IsDefined(RetentionPeriodInDays))
            {
                writer.WritePropertyName("retentionPeriodInDays"u8);
                writer.WriteNumberValue(RetentionPeriodInDays.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SizeInTbs))
            {
                writer.WritePropertyName("sizeInTbs"u8);
                writer.WriteNumberValue(SizeInTbs.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TimeAvailableTil))
            {
                writer.WritePropertyName("timeAvailableTil"u8);
                writer.WriteStringValue(TimeAvailableTil.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(TimeStarted))
            {
                writer.WritePropertyName("timeStarted"u8);
                writer.WriteStringValue(TimeStarted);
            }
            if (options.Format != "W" && Optional.IsDefined(TimeEnded))
            {
                writer.WritePropertyName("timeEnded"u8);
                writer.WriteStringValue(TimeEnded);
            }
            if (options.Format != "W" && Optional.IsDefined(BackupType))
            {
                writer.WritePropertyName("backupType"u8);
                writer.WriteStringValue(BackupType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDatabaseBackupProperties IJsonModel<AutonomousDatabaseBackupProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBackupProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDatabaseBackupProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDatabaseBackupProperties(document.RootElement, options);
        }

        internal static AutonomousDatabaseBackupProperties DeserializeAutonomousDatabaseBackupProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier autonomousDatabaseOcid = default;
            double? databaseSizeInTbs = default;
            string dbVersion = default;
            string displayName = default;
            ResourceIdentifier ocid = default;
            bool? isAutomatic = default;
            bool? isRestorable = default;
            string lifecycleDetails = default;
            AutonomousDatabaseBackupLifecycleState? lifecycleState = default;
            int? retentionPeriodInDays = default;
            double? sizeInTbs = default;
            DateTimeOffset? timeAvailableTil = default;
            string timeStarted = default;
            string timeEnded = default;
            AutonomousDatabaseBackupType? backupType = default;
            OracleDatabaseProvisioningState? provisioningState = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("autonomousDatabaseOcid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autonomousDatabaseOcid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("databaseSizeInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    databaseSizeInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("dbVersion"u8))
                {
                    dbVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ocid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ocid = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isAutomatic"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAutomatic = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isRestorable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRestorable = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lifecycleDetails"u8))
                {
                    lifecycleDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lifecycleState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lifecycleState = new AutonomousDatabaseBackupLifecycleState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("retentionPeriodInDays"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retentionPeriodInDays = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("sizeInTbs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sizeInTbs = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("timeAvailableTil"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeAvailableTil = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("timeStarted"u8))
                {
                    timeStarted = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timeEnded"u8))
                {
                    timeEnded = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("backupType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupType = new AutonomousDatabaseBackupType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new OracleDatabaseProvisioningState(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDatabaseBackupProperties(
                autonomousDatabaseOcid,
                databaseSizeInTbs,
                dbVersion,
                displayName,
                ocid,
                isAutomatic,
                isRestorable,
                lifecycleDetails,
                lifecycleState,
                retentionPeriodInDays,
                sizeInTbs,
                timeAvailableTil,
                timeStarted,
                timeEnded,
                backupType,
                provisioningState,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDatabaseBackupProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBackupProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseBackupProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDatabaseBackupProperties IPersistableModel<AutonomousDatabaseBackupProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDatabaseBackupProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDatabaseBackupProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDatabaseBackupProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDatabaseBackupProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
