// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> The type used for update operations of the AutonomousDatabaseBackup. </summary>
    public partial class AutonomousDatabaseBackupPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseBackupPatch"/>. </summary>
        public AutonomousDatabaseBackupPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseBackupPatch"/>. </summary>
        /// <param name="properties"> The updatable properties of the AutonomousDatabaseBackup. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutonomousDatabaseBackupPatch(AutonomousDatabaseBackupUpdateProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The updatable properties of the AutonomousDatabaseBackup. </summary>
        internal AutonomousDatabaseBackupUpdateProperties Properties { get; set; }
        /// <summary> Retention period, in days, for long-term backups. </summary>
        public int? AutonomousDatabaseBackupUpdateRetentionPeriodInDays
        {
            get => Properties is null ? default : Properties.RetentionPeriodInDays;
            set
            {
                if (Properties is null)
                    Properties = new AutonomousDatabaseBackupUpdateProperties();
                Properties.RetentionPeriodInDays = value;
            }
        }
    }
}
