// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Autonomous database backup lifecycle state enum. </summary>
    public readonly partial struct AutonomousDatabaseBackupLifecycleState : IEquatable<AutonomousDatabaseBackupLifecycleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutonomousDatabaseBackupLifecycleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutonomousDatabaseBackupLifecycleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string ActiveValue = "Active";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";
        private const string UpdatingValue = "Updating";

        /// <summary> AutonomousDatabase backup is creating. </summary>
        public static AutonomousDatabaseBackupLifecycleState Creating { get; } = new AutonomousDatabaseBackupLifecycleState(CreatingValue);
        /// <summary> AutonomousDatabase backup is active. </summary>
        public static AutonomousDatabaseBackupLifecycleState Active { get; } = new AutonomousDatabaseBackupLifecycleState(ActiveValue);
        /// <summary> AutonomousDatabase backup is deleting. </summary>
        public static AutonomousDatabaseBackupLifecycleState Deleting { get; } = new AutonomousDatabaseBackupLifecycleState(DeletingValue);
        /// <summary> AutonomousDatabase backup is failed. </summary>
        public static AutonomousDatabaseBackupLifecycleState Failed { get; } = new AutonomousDatabaseBackupLifecycleState(FailedValue);
        /// <summary> AutonomousDatabase backup is updating. </summary>
        public static AutonomousDatabaseBackupLifecycleState Updating { get; } = new AutonomousDatabaseBackupLifecycleState(UpdatingValue);
        /// <summary> Determines if two <see cref="AutonomousDatabaseBackupLifecycleState"/> values are the same. </summary>
        public static bool operator ==(AutonomousDatabaseBackupLifecycleState left, AutonomousDatabaseBackupLifecycleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutonomousDatabaseBackupLifecycleState"/> values are not the same. </summary>
        public static bool operator !=(AutonomousDatabaseBackupLifecycleState left, AutonomousDatabaseBackupLifecycleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutonomousDatabaseBackupLifecycleState"/>. </summary>
        public static implicit operator AutonomousDatabaseBackupLifecycleState(string value) => new AutonomousDatabaseBackupLifecycleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutonomousDatabaseBackupLifecycleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutonomousDatabaseBackupLifecycleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
