// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> AutonomousDbVersion resource model. </summary>
    public partial class AutonomousDBVersionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutonomousDBVersionProperties"/>. </summary>
        /// <param name="version"> Supported Autonomous Db versions. </param>
        public AutonomousDBVersionProperties(string version)
        {
            Version = version;
        }

        /// <summary> Initializes a new instance of <see cref="AutonomousDBVersionProperties"/>. </summary>
        /// <param name="version"> Supported Autonomous Db versions. </param>
        /// <param name="dbWorkload"> The Autonomous Database workload type. </param>
        /// <param name="isDefaultForFree"> True if this version of the Oracle Database software's default is free. </param>
        /// <param name="isDefaultForPaid"> True if this version of the Oracle Database software's default is paid. </param>
        /// <param name="isFreeTierEnabled"> True if this version of the Oracle Database software can be used for Always-Free Autonomous Databases. </param>
        /// <param name="isPaidEnabled"> True if this version of the Oracle Database software has payments enabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutonomousDBVersionProperties(string version, AutonomousDatabaseWorkloadType? dbWorkload, bool? isDefaultForFree, bool? isDefaultForPaid, bool? isFreeTierEnabled, bool? isPaidEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Version = version;
            DBWorkload = dbWorkload;
            IsDefaultForFree = isDefaultForFree;
            IsDefaultForPaid = isDefaultForPaid;
            IsFreeTierEnabled = isFreeTierEnabled;
            IsPaidEnabled = isPaidEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutonomousDBVersionProperties"/> for deserialization. </summary>
        internal AutonomousDBVersionProperties()
        {
        }

        /// <summary> Supported Autonomous Db versions. </summary>
        public string Version { get; }
        /// <summary> The Autonomous Database workload type. </summary>
        public AutonomousDatabaseWorkloadType? DBWorkload { get; }
        /// <summary> True if this version of the Oracle Database software's default is free. </summary>
        public bool? IsDefaultForFree { get; }
        /// <summary> True if this version of the Oracle Database software's default is paid. </summary>
        public bool? IsDefaultForPaid { get; }
        /// <summary> True if this version of the Oracle Database software can be used for Always-Free Autonomous Databases. </summary>
        public bool? IsFreeTierEnabled { get; }
        /// <summary> True if this version of the Oracle Database software has payments enabled. </summary>
        public bool? IsPaidEnabled { get; }
    }
}
