// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    public partial class AutonomousDBVersionProperties : IUtf8JsonSerializable, IJsonModel<AutonomousDBVersionProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AutonomousDBVersionProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AutonomousDBVersionProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDBVersionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDBVersionProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W")
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (options.Format != "W" && Optional.IsDefined(DBWorkload))
            {
                writer.WritePropertyName("dbWorkload"u8);
                writer.WriteStringValue(DBWorkload.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(IsDefaultForFree))
            {
                writer.WritePropertyName("isDefaultForFree"u8);
                writer.WriteBooleanValue(IsDefaultForFree.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsDefaultForPaid))
            {
                writer.WritePropertyName("isDefaultForPaid"u8);
                writer.WriteBooleanValue(IsDefaultForPaid.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsFreeTierEnabled))
            {
                writer.WritePropertyName("isFreeTierEnabled"u8);
                writer.WriteBooleanValue(IsFreeTierEnabled.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsPaidEnabled))
            {
                writer.WritePropertyName("isPaidEnabled"u8);
                writer.WriteBooleanValue(IsPaidEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AutonomousDBVersionProperties IJsonModel<AutonomousDBVersionProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDBVersionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AutonomousDBVersionProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAutonomousDBVersionProperties(document.RootElement, options);
        }

        internal static AutonomousDBVersionProperties DeserializeAutonomousDBVersionProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string version = default;
            AutonomousDatabaseWorkloadType? dbWorkload = default;
            bool? isDefaultForFree = default;
            bool? isDefaultForPaid = default;
            bool? isFreeTierEnabled = default;
            bool? isPaidEnabled = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dbWorkload"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbWorkload = new AutonomousDatabaseWorkloadType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isDefaultForFree"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDefaultForFree = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isDefaultForPaid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDefaultForPaid = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isFreeTierEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isFreeTierEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isPaidEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isPaidEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AutonomousDBVersionProperties(
                version,
                dbWorkload,
                isDefaultForFree,
                isDefaultForPaid,
                isFreeTierEnabled,
                isPaidEnabled,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AutonomousDBVersionProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDBVersionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AutonomousDBVersionProperties)} does not support writing '{options.Format}' format.");
            }
        }

        AutonomousDBVersionProperties IPersistableModel<AutonomousDBVersionProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AutonomousDBVersionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAutonomousDBVersionProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AutonomousDBVersionProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AutonomousDBVersionProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
