// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.OracleDatabase.Models;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class SaasSubscriptionDetailsOperationSource : IOperationSource<SaasSubscriptionDetails>
    {
        SaasSubscriptionDetails IOperationSource<SaasSubscriptionDetails>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return SaasSubscriptionDetails.DeserializeSaasSubscriptionDetails(document.RootElement);
        }

        async ValueTask<SaasSubscriptionDetails> IOperationSource<SaasSubscriptionDetails>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return SaasSubscriptionDetails.DeserializeSaasSubscriptionDetails(document.RootElement);
        }
    }
}
