// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class OracleSubscriptionOperationSource : IOperationSource<OracleSubscriptionResource>
    {
        private readonly ArmClient _client;

        internal OracleSubscriptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        OracleSubscriptionResource IOperationSource<OracleSubscriptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OracleSubscriptionData.DeserializeOracleSubscriptionData(document.RootElement);
            return new OracleSubscriptionResource(_client, data);
        }

        async ValueTask<OracleSubscriptionResource> IOperationSource<OracleSubscriptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OracleSubscriptionData.DeserializeOracleSubscriptionData(document.RootElement);
            return new OracleSubscriptionResource(_client, data);
        }
    }
}
