// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class CloudVmClusterVirtualNetworkAddressOperationSource : IOperationSource<CloudVmClusterVirtualNetworkAddressResource>
    {
        private readonly ArmClient _client;

        internal CloudVmClusterVirtualNetworkAddressOperationSource(ArmClient client)
        {
            _client = client;
        }

        CloudVmClusterVirtualNetworkAddressResource IOperationSource<CloudVmClusterVirtualNetworkAddressResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CloudVmClusterVirtualNetworkAddressData.DeserializeCloudVmClusterVirtualNetworkAddressData(document.RootElement);
            return new CloudVmClusterVirtualNetworkAddressResource(_client, data);
        }

        async ValueTask<CloudVmClusterVirtualNetworkAddressResource> IOperationSource<CloudVmClusterVirtualNetworkAddressResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CloudVmClusterVirtualNetworkAddressData.DeserializeCloudVmClusterVirtualNetworkAddressData(document.RootElement);
            return new CloudVmClusterVirtualNetworkAddressResource(_client, data);
        }
    }
}
