// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class CloudVmClusterOperationSource : IOperationSource<CloudVmClusterResource>
    {
        private readonly ArmClient _client;

        internal CloudVmClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        CloudVmClusterResource IOperationSource<CloudVmClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CloudVmClusterData.DeserializeCloudVmClusterData(document.RootElement);
            return new CloudVmClusterResource(_client, data);
        }

        async ValueTask<CloudVmClusterResource> IOperationSource<CloudVmClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CloudVmClusterData.DeserializeCloudVmClusterData(document.RootElement);
            return new CloudVmClusterResource(_client, data);
        }
    }
}
