// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class CloudExadataInfrastructureOperationSource : IOperationSource<CloudExadataInfrastructureResource>
    {
        private readonly ArmClient _client;

        internal CloudExadataInfrastructureOperationSource(ArmClient client)
        {
            _client = client;
        }

        CloudExadataInfrastructureResource IOperationSource<CloudExadataInfrastructureResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CloudExadataInfrastructureData.DeserializeCloudExadataInfrastructureData(document.RootElement);
            return new CloudExadataInfrastructureResource(_client, data);
        }

        async ValueTask<CloudExadataInfrastructureResource> IOperationSource<CloudExadataInfrastructureResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CloudExadataInfrastructureData.DeserializeCloudExadataInfrastructureData(document.RootElement);
            return new CloudExadataInfrastructureResource(_client, data);
        }
    }
}
