// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase
{
    internal class AutonomousDatabaseBackupOperationSource : IOperationSource<AutonomousDatabaseBackupResource>
    {
        private readonly ArmClient _client;

        internal AutonomousDatabaseBackupOperationSource(ArmClient client)
        {
            _client = client;
        }

        AutonomousDatabaseBackupResource IOperationSource<AutonomousDatabaseBackupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AutonomousDatabaseBackupData.DeserializeAutonomousDatabaseBackupData(document.RootElement);
            return new AutonomousDatabaseBackupResource(_client, data);
        }

        async ValueTask<AutonomousDatabaseBackupResource> IOperationSource<AutonomousDatabaseBackupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AutonomousDatabaseBackupData.DeserializeAutonomousDatabaseBackupData(document.RootElement);
            return new AutonomousDatabaseBackupResource(_client, data);
        }
    }
}
