// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OracleDatabase.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableOracleDatabaseResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableOracleDatabaseResourceGroupResource"/> class for mocking. </summary>
        protected MockableOracleDatabaseResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableOracleDatabaseResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableOracleDatabaseResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AutonomousDatabaseResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of AutonomousDatabaseResources and their operations over a AutonomousDatabaseResource. </returns>
        public virtual AutonomousDatabaseCollection GetAutonomousDatabases()
        {
            return GetCachedClient(client => new AutonomousDatabaseCollection(client, Id));
        }

        /// <summary>
        /// Get a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutonomousDatabaseResource>> GetAutonomousDatabaseAsync(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            return await GetAutonomousDatabases().GetAsync(autonomousdatabasename, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutonomousDatabaseResource> GetAutonomousDatabase(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            return GetAutonomousDatabases().Get(autonomousdatabasename, cancellationToken);
        }

        /// <summary> Gets a collection of CloudExadataInfrastructureResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of CloudExadataInfrastructureResources and their operations over a CloudExadataInfrastructureResource. </returns>
        public virtual CloudExadataInfrastructureCollection GetCloudExadataInfrastructures()
        {
            return GetCachedClient(client => new CloudExadataInfrastructureCollection(client, Id));
        }

        /// <summary>
        /// Get a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<CloudExadataInfrastructureResource>> GetCloudExadataInfrastructureAsync(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            return await GetCloudExadataInfrastructures().GetAsync(cloudexadatainfrastructurename, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<CloudExadataInfrastructureResource> GetCloudExadataInfrastructure(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            return GetCloudExadataInfrastructures().Get(cloudexadatainfrastructurename, cancellationToken);
        }

        /// <summary> Gets a collection of CloudVmClusterResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of CloudVmClusterResources and their operations over a CloudVmClusterResource. </returns>
        public virtual CloudVmClusterCollection GetCloudVmClusters()
        {
            return GetCachedClient(client => new CloudVmClusterCollection(client, Id));
        }

        /// <summary>
        /// Get a CloudVmCluster
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudVmClusters/{cloudvmclustername}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudVmClusters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudVmClusterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudvmclustername"> CloudVmCluster name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudvmclustername"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="cloudvmclustername"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<CloudVmClusterResource>> GetCloudVmClusterAsync(string cloudvmclustername, CancellationToken cancellationToken = default)
        {
            return await GetCloudVmClusters().GetAsync(cloudvmclustername, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a CloudVmCluster
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudVmClusters/{cloudvmclustername}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudVmClusters_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudVmClusterResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudvmclustername"> CloudVmCluster name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudvmclustername"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="cloudvmclustername"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<CloudVmClusterResource> GetCloudVmCluster(string cloudvmclustername, CancellationToken cancellationToken = default)
        {
            return GetCloudVmClusters().Get(cloudvmclustername, cancellationToken);
        }
    }
}
