// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="CloudExadataInfrastructureResource"/> and their operations.
    /// Each <see cref="CloudExadataInfrastructureResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="CloudExadataInfrastructureCollection"/> instance call the GetCloudExadataInfrastructures method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class CloudExadataInfrastructureCollection : ArmCollection, IEnumerable<CloudExadataInfrastructureResource>, IAsyncEnumerable<CloudExadataInfrastructureResource>
    {
        private readonly ClientDiagnostics _cloudExadataInfrastructureClientDiagnostics;
        private readonly CloudExadataInfrastructuresRestOperations _cloudExadataInfrastructureRestClient;

        /// <summary> Initializes a new instance of the <see cref="CloudExadataInfrastructureCollection"/> class for mocking. </summary>
        protected CloudExadataInfrastructureCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="CloudExadataInfrastructureCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal CloudExadataInfrastructureCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _cloudExadataInfrastructureClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", CloudExadataInfrastructureResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(CloudExadataInfrastructureResource.ResourceType, out string cloudExadataInfrastructureApiVersion);
            _cloudExadataInfrastructureRestClient = new CloudExadataInfrastructuresRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, cloudExadataInfrastructureApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<CloudExadataInfrastructureResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string cloudexadatainfrastructurename, CloudExadataInfrastructureData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _cloudExadataInfrastructureRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, data, cancellationToken).ConfigureAwait(false);
                var operation = new OracleDatabaseArmOperation<CloudExadataInfrastructureResource>(new CloudExadataInfrastructureOperationSource(Client), _cloudExadataInfrastructureClientDiagnostics, Pipeline, _cloudExadataInfrastructureRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<CloudExadataInfrastructureResource> CreateOrUpdate(WaitUntil waitUntil, string cloudexadatainfrastructurename, CloudExadataInfrastructureData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _cloudExadataInfrastructureRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, data, cancellationToken);
                var operation = new OracleDatabaseArmOperation<CloudExadataInfrastructureResource>(new CloudExadataInfrastructureOperationSource(Client), _cloudExadataInfrastructureClientDiagnostics, Pipeline, _cloudExadataInfrastructureRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual async Task<Response<CloudExadataInfrastructureResource>> GetAsync(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.Get");
            scope.Start();
            try
            {
                var response = await _cloudExadataInfrastructureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new CloudExadataInfrastructureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a CloudExadataInfrastructure
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual Response<CloudExadataInfrastructureResource> Get(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.Get");
            scope.Start();
            try
            {
                var response = _cloudExadataInfrastructureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new CloudExadataInfrastructureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List CloudExadataInfrastructure resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="CloudExadataInfrastructureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<CloudExadataInfrastructureResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cloudExadataInfrastructureRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cloudExadataInfrastructureRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new CloudExadataInfrastructureResource(Client, CloudExadataInfrastructureData.DeserializeCloudExadataInfrastructureData(e)), _cloudExadataInfrastructureClientDiagnostics, Pipeline, "CloudExadataInfrastructureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List CloudExadataInfrastructure resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="CloudExadataInfrastructureResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<CloudExadataInfrastructureResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _cloudExadataInfrastructureRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _cloudExadataInfrastructureRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new CloudExadataInfrastructureResource(Client, CloudExadataInfrastructureData.DeserializeCloudExadataInfrastructureData(e)), _cloudExadataInfrastructureClientDiagnostics, Pipeline, "CloudExadataInfrastructureCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.Exists");
            scope.Start();
            try
            {
                var response = await _cloudExadataInfrastructureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual Response<bool> Exists(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.Exists");
            scope.Start();
            try
            {
                var response = _cloudExadataInfrastructureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual async Task<NullableResponse<CloudExadataInfrastructureResource>> GetIfExistsAsync(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _cloudExadataInfrastructureRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<CloudExadataInfrastructureResource>(response.GetRawResponse());
                return Response.FromValue(new CloudExadataInfrastructureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/cloudExadataInfrastructures/{cloudexadatainfrastructurename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CloudExadataInfrastructures_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CloudExadataInfrastructureResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cloudexadatainfrastructurename"> CloudExadataInfrastructure name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="cloudexadatainfrastructurename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="cloudexadatainfrastructurename"/> is null. </exception>
        public virtual NullableResponse<CloudExadataInfrastructureResource> GetIfExists(string cloudexadatainfrastructurename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(cloudexadatainfrastructurename, nameof(cloudexadatainfrastructurename));

            using var scope = _cloudExadataInfrastructureClientDiagnostics.CreateScope("CloudExadataInfrastructureCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _cloudExadataInfrastructureRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, cloudexadatainfrastructurename, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<CloudExadataInfrastructureResource>(response.GetRawResponse());
                return Response.FromValue(new CloudExadataInfrastructureResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<CloudExadataInfrastructureResource> IEnumerable<CloudExadataInfrastructureResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<CloudExadataInfrastructureResource> IAsyncEnumerable<CloudExadataInfrastructureResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
