// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="AutonomousDatabaseResource"/> and their operations.
    /// Each <see cref="AutonomousDatabaseResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get an <see cref="AutonomousDatabaseCollection"/> instance call the GetAutonomousDatabases method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class AutonomousDatabaseCollection : ArmCollection, IEnumerable<AutonomousDatabaseResource>, IAsyncEnumerable<AutonomousDatabaseResource>
    {
        private readonly ClientDiagnostics _autonomousDatabaseClientDiagnostics;
        private readonly AutonomousDatabasesRestOperations _autonomousDatabaseRestClient;

        /// <summary> Initializes a new instance of the <see cref="AutonomousDatabaseCollection"/> class for mocking. </summary>
        protected AutonomousDatabaseCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AutonomousDatabaseCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AutonomousDatabaseCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _autonomousDatabaseClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", AutonomousDatabaseResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AutonomousDatabaseResource.ResourceType, out string autonomousDatabaseApiVersion);
            _autonomousDatabaseRestClient = new AutonomousDatabasesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, autonomousDatabaseApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AutonomousDatabaseResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string autonomousdatabasename, AutonomousDatabaseData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, data, cancellationToken).ConfigureAwait(false);
                var operation = new OracleDatabaseArmOperation<AutonomousDatabaseResource>(new AutonomousDatabaseOperationSource(Client), _autonomousDatabaseClientDiagnostics, Pipeline, _autonomousDatabaseRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AutonomousDatabaseResource> CreateOrUpdate(WaitUntil waitUntil, string autonomousdatabasename, AutonomousDatabaseData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, data, cancellationToken);
                var operation = new OracleDatabaseArmOperation<AutonomousDatabaseResource>(new AutonomousDatabaseOperationSource(Client), _autonomousDatabaseClientDiagnostics, Pipeline, _autonomousDatabaseRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual async Task<Response<AutonomousDatabaseResource>> GetAsync(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.Get");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutonomousDatabase
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual Response<AutonomousDatabaseResource> Get(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.Get");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List AutonomousDatabase resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AutonomousDatabaseResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AutonomousDatabaseResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autonomousDatabaseRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autonomousDatabaseRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AutonomousDatabaseResource(Client, AutonomousDatabaseData.DeserializeAutonomousDatabaseData(e)), _autonomousDatabaseClientDiagnostics, Pipeline, "AutonomousDatabaseCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List AutonomousDatabase resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AutonomousDatabaseResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AutonomousDatabaseResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autonomousDatabaseRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autonomousDatabaseRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AutonomousDatabaseResource(Client, AutonomousDatabaseData.DeserializeAutonomousDatabaseData(e)), _autonomousDatabaseClientDiagnostics, Pipeline, "AutonomousDatabaseCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.Exists");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual Response<bool> Exists(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.Exists");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual async Task<NullableResponse<AutonomousDatabaseResource>> GetIfExistsAsync(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AutonomousDatabaseResource>(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Oracle.Database/autonomousDatabases/{autonomousdatabasename}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabases_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="autonomousdatabasename"> The database name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="autonomousdatabasename"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="autonomousdatabasename"/> is null. </exception>
        public virtual NullableResponse<AutonomousDatabaseResource> GetIfExists(string autonomousdatabasename, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(autonomousdatabasename, nameof(autonomousdatabasename));

            using var scope = _autonomousDatabaseClientDiagnostics.CreateScope("AutonomousDatabaseCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, autonomousdatabasename, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AutonomousDatabaseResource>(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AutonomousDatabaseResource> IEnumerable<AutonomousDatabaseResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AutonomousDatabaseResource> IAsyncEnumerable<AutonomousDatabaseResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
