// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A class representing a collection of <see cref="AutonomousDatabaseCharacterSetResource"/> and their operations.
    /// Each <see cref="AutonomousDatabaseCharacterSetResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="AutonomousDatabaseCharacterSetCollection"/> instance call the GetAutonomousDatabaseCharacterSets method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class AutonomousDatabaseCharacterSetCollection : ArmCollection, IEnumerable<AutonomousDatabaseCharacterSetResource>, IAsyncEnumerable<AutonomousDatabaseCharacterSetResource>
    {
        private readonly ClientDiagnostics _autonomousDatabaseCharacterSetClientDiagnostics;
        private readonly AutonomousDatabaseCharacterSetsRestOperations _autonomousDatabaseCharacterSetRestClient;
        private readonly AzureLocation _location;

        /// <summary> Initializes a new instance of the <see cref="AutonomousDatabaseCharacterSetCollection"/> class for mocking. </summary>
        protected AutonomousDatabaseCharacterSetCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AutonomousDatabaseCharacterSetCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="location"> The name of the Azure region. </param>
        internal AutonomousDatabaseCharacterSetCollection(ArmClient client, ResourceIdentifier id, AzureLocation location) : base(client, id)
        {
            _location = location;
            _autonomousDatabaseCharacterSetClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", AutonomousDatabaseCharacterSetResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AutonomousDatabaseCharacterSetResource.ResourceType, out string autonomousDatabaseCharacterSetApiVersion);
            _autonomousDatabaseCharacterSetRestClient = new AutonomousDatabaseCharacterSetsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, autonomousDatabaseCharacterSetApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a AutonomousDatabaseCharacterSet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual async Task<Response<AutonomousDatabaseCharacterSetResource>> GetAsync(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.Get");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseCharacterSetRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseCharacterSetResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutonomousDatabaseCharacterSet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual Response<AutonomousDatabaseCharacterSetResource> Get(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.Get");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseCharacterSetRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseCharacterSetResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List AutonomousDatabaseCharacterSet resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AutonomousDatabaseCharacterSetResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AutonomousDatabaseCharacterSetResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autonomousDatabaseCharacterSetRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autonomousDatabaseCharacterSetRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AutonomousDatabaseCharacterSetResource(Client, AutonomousDatabaseCharacterSetData.DeserializeAutonomousDatabaseCharacterSetData(e)), _autonomousDatabaseCharacterSetClientDiagnostics, Pipeline, "AutonomousDatabaseCharacterSetCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List AutonomousDatabaseCharacterSet resources by Location
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_ListByLocation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AutonomousDatabaseCharacterSetResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AutonomousDatabaseCharacterSetResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _autonomousDatabaseCharacterSetRestClient.CreateListByLocationRequest(Id.SubscriptionId, new AzureLocation(_location));
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _autonomousDatabaseCharacterSetRestClient.CreateListByLocationNextPageRequest(nextLink, Id.SubscriptionId, new AzureLocation(_location));
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AutonomousDatabaseCharacterSetResource(Client, AutonomousDatabaseCharacterSetData.DeserializeAutonomousDatabaseCharacterSetData(e)), _autonomousDatabaseCharacterSetClientDiagnostics, Pipeline, "AutonomousDatabaseCharacterSetCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.Exists");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseCharacterSetRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual Response<bool> Exists(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.Exists");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseCharacterSetRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual async Task<NullableResponse<AutonomousDatabaseCharacterSetResource>> GetIfExistsAsync(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _autonomousDatabaseCharacterSetRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AutonomousDatabaseCharacterSetResource>(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseCharacterSetResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDatabaseCharacterSets/{adbscharsetname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseCharacterSets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDatabaseCharacterSetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="adbscharsetname"> AutonomousDatabaseCharacterSet name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="adbscharsetname"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="adbscharsetname"/> is null. </exception>
        public virtual NullableResponse<AutonomousDatabaseCharacterSetResource> GetIfExists(string adbscharsetname, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(adbscharsetname, nameof(adbscharsetname));

            using var scope = _autonomousDatabaseCharacterSetClientDiagnostics.CreateScope("AutonomousDatabaseCharacterSetCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _autonomousDatabaseCharacterSetRestClient.Get(Id.SubscriptionId, new AzureLocation(_location), adbscharsetname, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AutonomousDatabaseCharacterSetResource>(response.GetRawResponse());
                return Response.FromValue(new AutonomousDatabaseCharacterSetResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AutonomousDatabaseCharacterSetResource> IEnumerable<AutonomousDatabaseCharacterSetResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AutonomousDatabaseCharacterSetResource> IAsyncEnumerable<AutonomousDatabaseCharacterSetResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
