// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OracleDatabase
{
    /// <summary>
    /// A Class representing an AutonomousDBVersion along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="AutonomousDBVersionResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetAutonomousDBVersionResource method.
    /// Otherwise you can get one from its parent resource <see cref="SubscriptionResource"/> using the GetAutonomousDBVersion method.
    /// </summary>
    public partial class AutonomousDBVersionResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="AutonomousDBVersionResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="location"> The location. </param>
        /// <param name="autonomousdbversionsname"> The autonomousdbversionsname. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, AzureLocation location, string autonomousdbversionsname)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDbVersions/{autonomousdbversionsname}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _autonomousDBVersionAutonomousDatabaseVersionsClientDiagnostics;
        private readonly AutonomousDatabaseVersionsRestOperations _autonomousDBVersionAutonomousDatabaseVersionsRestClient;
        private readonly AutonomousDBVersionData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Oracle.Database/locations/autonomousDbVersions";

        /// <summary> Initializes a new instance of the <see cref="AutonomousDBVersionResource"/> class for mocking. </summary>
        protected AutonomousDBVersionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AutonomousDBVersionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal AutonomousDBVersionResource(ArmClient client, AutonomousDBVersionData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="AutonomousDBVersionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal AutonomousDBVersionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _autonomousDBVersionAutonomousDatabaseVersionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OracleDatabase", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string autonomousDBVersionAutonomousDatabaseVersionsApiVersion);
            _autonomousDBVersionAutonomousDatabaseVersionsRestClient = new AutonomousDatabaseVersionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, autonomousDBVersionAutonomousDatabaseVersionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual AutonomousDBVersionData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a AutonomousDbVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDbVersions/{autonomousdbversionsname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDBVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AutonomousDBVersionResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _autonomousDBVersionAutonomousDatabaseVersionsClientDiagnostics.CreateScope("AutonomousDBVersionResource.Get");
            scope.Start();
            try
            {
                var response = await _autonomousDBVersionAutonomousDatabaseVersionsRestClient.GetAsync(Id.SubscriptionId, new AzureLocation(Id.Parent.Name), Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDBVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AutonomousDbVersion
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Oracle.Database/locations/{location}/autonomousDbVersions/{autonomousdbversionsname}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AutonomousDatabaseVersions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutonomousDBVersionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AutonomousDBVersionResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _autonomousDBVersionAutonomousDatabaseVersionsClientDiagnostics.CreateScope("AutonomousDBVersionResource.Get");
            scope.Start();
            try
            {
                var response = _autonomousDBVersionAutonomousDatabaseVersionsRestClient.Get(Id.SubscriptionId, new AzureLocation(Id.Parent.Name), Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutonomousDBVersionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
