// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.OracleDatabase.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmOracleDatabaseModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="OracleDatabase.AutonomousDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties">
        /// The resource-specific properties for this resource.
        /// Please note <see cref="Models.AutonomousDatabaseBaseProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.AutonomousDatabaseCloneProperties"/> and <see cref="Models.AutonomousDatabaseProperties"/>.
        /// </param>
        /// <returns> A new <see cref="OracleDatabase.AutonomousDatabaseData"/> instance for mocking. </returns>
        public static AutonomousDatabaseData AutonomousDatabaseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, AutonomousDatabaseBaseProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AutonomousDatabaseData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseBaseProperties"/>. </summary>
        /// <param name="adminPassword"> Admin password. </param>
        /// <param name="dataBaseType"> Database type to be created. </param>
        /// <param name="autonomousMaintenanceScheduleType"> The maintenance schedule type of the Autonomous Database Serverless. </param>
        /// <param name="characterSet"> The character set for the autonomous database. </param>
        /// <param name="computeCount"> The compute amount (CPUs) available to the database. </param>
        /// <param name="computeModel"> The compute model of the Autonomous Database. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores to be made available to the database. </param>
        /// <param name="customerContacts"> Customer Contacts. </param>
        /// <param name="dataStorageSizeInTbs"> The quantity of data in the database, in terabytes. </param>
        /// <param name="dataStorageSizeInGbs"> The size, in gigabytes, of the data volume that will be created and attached to the database. </param>
        /// <param name="dbVersion"> A valid Oracle Database version for Autonomous Database. </param>
        /// <param name="dbWorkload"> The Autonomous Database workload type. </param>
        /// <param name="displayName"> The user-friendly name for the Autonomous Database. </param>
        /// <param name="isAutoScalingEnabled"> Indicates if auto scaling is enabled for the Autonomous Database CPU core count. </param>
        /// <param name="isAutoScalingForStorageEnabled"> Indicates if auto scaling is enabled for the Autonomous Database storage. </param>
        /// <param name="peerDBIds"> The list of [OCIDs](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs. </param>
        /// <param name="peerDBId"> The database OCID of the Disaster Recovery peer database, which is located in a different region from the current peer database. </param>
        /// <param name="isLocalDataGuardEnabled"> Indicates whether the Autonomous Database has local or called in-region Data Guard enabled. </param>
        /// <param name="isRemoteDataGuardEnabled"> Indicates whether the Autonomous Database has Cross Region Data Guard enabled. </param>
        /// <param name="localDisasterRecoveryType"> Indicates the local disaster recovery (DR) type of the Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover. </param>
        /// <param name="localStandbyDB"> Local Autonomous Disaster Recovery standby database details. </param>
        /// <param name="failedDataRecoveryInSeconds"> Indicates the number of seconds of data loss for a Data Guard failover. </param>
        /// <param name="isMtlsConnectionRequired"> Specifies if the Autonomous Database requires mTLS connections. </param>
        /// <param name="isPreviewVersionWithServiceTermsAccepted"> Specifies if the Autonomous Database preview version is being provisioned. </param>
        /// <param name="licenseModel"> The Oracle license model that applies to the Oracle Autonomous Database. The default is LICENSE_INCLUDED. </param>
        /// <param name="ncharacterSet"> The character set for the Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="lifecycleState"> Views lifecycleState. </param>
        /// <param name="scheduledOperations"> The list of scheduled operations. </param>
        /// <param name="privateEndpointIP"> The private endpoint Ip address for the resource. </param>
        /// <param name="privateEndpointLabel"> The resource's private endpoint label. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="subnetId"> Client subnet. </param>
        /// <param name="vnetId"> VNET for network connectivity. </param>
        /// <param name="createdOn"> The date and time that the database was created. </param>
        /// <param name="maintenanceBeginOn"> The date and time when maintenance will begin. </param>
        /// <param name="maintenanceEndOn"> The date and time when maintenance will end. </param>
        /// <param name="actualUsedDataStorageSizeInTbs"> The current amount of storage in use for user and system data, in terabytes (TB). </param>
        /// <param name="allocatedStorageSizeInTbs"> The amount of storage currently allocated for the database tables and billed for, rounded up. </param>
        /// <param name="apexDetails"> Information about Oracle APEX Application Development. </param>
        /// <param name="availableUpgradeVersions"> List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty. </param>
        /// <param name="connectionStrings"> The connection string used to connect to the Autonomous Database. </param>
        /// <param name="connectionUrls"> The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. </param>
        /// <param name="dataSafeStatus"> Status of the Data Safe registration for this Autonomous Database. </param>
        /// <param name="databaseEdition"> The Oracle Database Edition that applies to the Autonomous databases. </param>
        /// <param name="autonomousDatabaseId"> Autonomous Database ID. </param>
        /// <param name="inMemoryAreaInGbs"> The area assigned to In-Memory tables in Autonomous Database. </param>
        /// <param name="nextLongTermBackupCreatedOn"> The date and time when the next long-term backup would be created. </param>
        /// <param name="longTermBackupSchedule"> Details for the long-term backup schedule. </param>
        /// <param name="isPreview"> Indicates if the Autonomous Database version is a preview version. </param>
        /// <param name="localAdgAutoFailoverMaxDataLossLimit"> Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard. </param>
        /// <param name="memoryPerOracleComputeUnitInGbs"> The amount of memory (in GBs) enabled per ECPU or OCPU. </param>
        /// <param name="openMode"> Indicates the Autonomous Database mode. </param>
        /// <param name="operationsInsightsStatus"> Status of Operations Insights for this Autonomous Database. </param>
        /// <param name="permissionLevel"> The Autonomous Database permission level. </param>
        /// <param name="privateEndpoint"> The private endpoint for the resource. </param>
        /// <param name="provisionableCpus"> An array of CPU values that an Autonomous Database can be scaled to. </param>
        /// <param name="role"> The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled. </param>
        /// <param name="serviceConsoleUri"> The URL of the Service Console for the Autonomous Database. </param>
        /// <param name="sqlWebDeveloperUri"> The SQL Web Developer URL for the Oracle Autonomous Database. </param>
        /// <param name="supportedRegionsToCloneTo"> The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database. </param>
        /// <param name="dataGuardRoleChangedOn"> The date and time the Autonomous Data Guard role was switched for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseDeletedOn"> The date and time the Always Free database will be automatically deleted because of inactivity. </param>
        /// <param name="timeLocalDataGuardEnabled"> The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database. </param>
        /// <param name="lastFailoverHappenedOn"> The timestamp of the last failover operation. </param>
        /// <param name="lastRefreshHappenedOn"> The date and time when last refresh happened. </param>
        /// <param name="lastRefreshPointTimestamp"> The refresh point timestamp (UTC). </param>
        /// <param name="lastSwitchoverHappenedOn"> The timestamp of the last switchover operation for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseStoppedOn"> The date and time the Always Free database will be stopped because of inactivity. </param>
        /// <param name="usedDataStorageSizeInGbs"> The storage space consumed by Autonomous Database in GBs. </param>
        /// <param name="usedDataStorageSizeInTbs"> The amount of storage that has been used, in terabytes. </param>
        /// <param name="ocid"> Database ocid. </param>
        /// <param name="backupRetentionPeriodInDays"> Retention period, in days, for long-term backups. </param>
        /// <param name="whitelistedIPs"> The client IP access control list (ACL). This is an array of CIDR notations and/or IP addresses. Values should be separate strings, separated by commas. Example: ['1.1.1.1','1.1.1.0/24','1.1.2.25']. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseBaseProperties"/> instance for mocking. </returns>
        public static AutonomousDatabaseBaseProperties AutonomousDatabaseBaseProperties(string adminPassword = null, string dataBaseType = null, AutonomousMaintenanceScheduleType? autonomousMaintenanceScheduleType = null, string characterSet = null, float? computeCount = null, AutonomousDatabaseComputeModel? computeModel = null, int? cpuCoreCount = null, IEnumerable<OracleCustomerContact> customerContacts = null, int? dataStorageSizeInTbs = null, int? dataStorageSizeInGbs = null, string dbVersion = null, AutonomousDatabaseWorkloadType? dbWorkload = null, string displayName = null, bool? isAutoScalingEnabled = null, bool? isAutoScalingForStorageEnabled = null, IEnumerable<string> peerDBIds = null, string peerDBId = null, bool? isLocalDataGuardEnabled = null, bool? isRemoteDataGuardEnabled = null, DisasterRecoveryType? localDisasterRecoveryType = null, AutonomousDatabaseStandbySummary localStandbyDB = null, int? failedDataRecoveryInSeconds = null, bool? isMtlsConnectionRequired = null, bool? isPreviewVersionWithServiceTermsAccepted = null, OracleLicenseModel? licenseModel = null, string ncharacterSet = null, string lifecycleDetails = null, OracleDatabaseProvisioningState? provisioningState = null, AutonomousDatabaseLifecycleState? lifecycleState = null, ScheduledOperationsType scheduledOperations = null, string privateEndpointIP = null, string privateEndpointLabel = null, Uri ociUri = null, ResourceIdentifier subnetId = null, ResourceIdentifier vnetId = null, DateTimeOffset? createdOn = null, DateTimeOffset? maintenanceBeginOn = null, DateTimeOffset? maintenanceEndOn = null, double? actualUsedDataStorageSizeInTbs = null, double? allocatedStorageSizeInTbs = null, OracleApexDetailsType apexDetails = null, IEnumerable<string> availableUpgradeVersions = null, AutonomousDatabaseConnectionStrings connectionStrings = null, AutonomousDatabaseConnectionUrls connectionUrls = null, DataSafeStatusType? dataSafeStatus = null, OracleDatabaseEditionType? databaseEdition = null, ResourceIdentifier autonomousDatabaseId = null, int? inMemoryAreaInGbs = null, DateTimeOffset? nextLongTermBackupCreatedOn = null, LongTermBackUpScheduleDetails longTermBackupSchedule = null, bool? isPreview = null, int? localAdgAutoFailoverMaxDataLossLimit = null, int? memoryPerOracleComputeUnitInGbs = null, AutonomousDatabaseModeType? openMode = null, OperationsInsightsStatusType? operationsInsightsStatus = null, AutonomousDatabasePermissionLevelType? permissionLevel = null, string privateEndpoint = null, IEnumerable<int> provisionableCpus = null, DataGuardRoleType? role = null, Uri serviceConsoleUri = null, Uri sqlWebDeveloperUri = null, IEnumerable<string> supportedRegionsToCloneTo = null, DateTimeOffset? dataGuardRoleChangedOn = null, DateTimeOffset? freeAutonomousDatabaseDeletedOn = null, string timeLocalDataGuardEnabled = null, DateTimeOffset? lastFailoverHappenedOn = null, DateTimeOffset? lastRefreshHappenedOn = null, DateTimeOffset? lastRefreshPointTimestamp = null, DateTimeOffset? lastSwitchoverHappenedOn = null, DateTimeOffset? freeAutonomousDatabaseStoppedOn = null, int? usedDataStorageSizeInGbs = null, int? usedDataStorageSizeInTbs = null, ResourceIdentifier ocid = null, int? backupRetentionPeriodInDays = null, IEnumerable<string> whitelistedIPs = null)
        {
            customerContacts ??= new List<OracleCustomerContact>();
            peerDBIds ??= new List<string>();
            availableUpgradeVersions ??= new List<string>();
            provisionableCpus ??= new List<int>();
            supportedRegionsToCloneTo ??= new List<string>();
            whitelistedIPs ??= new List<string>();

            return new UnknownAutonomousDatabaseBaseProperties(
                adminPassword,
                dataBaseType == null ? default : new OracleDataBaseType(dataBaseType),
                autonomousMaintenanceScheduleType,
                characterSet,
                computeCount,
                computeModel,
                cpuCoreCount,
                customerContacts?.ToList(),
                dataStorageSizeInTbs,
                dataStorageSizeInGbs,
                dbVersion,
                dbWorkload,
                displayName,
                isAutoScalingEnabled,
                isAutoScalingForStorageEnabled,
                peerDBIds?.ToList(),
                peerDBId,
                isLocalDataGuardEnabled,
                isRemoteDataGuardEnabled,
                localDisasterRecoveryType,
                localStandbyDB,
                failedDataRecoveryInSeconds,
                isMtlsConnectionRequired,
                isPreviewVersionWithServiceTermsAccepted,
                licenseModel,
                ncharacterSet,
                lifecycleDetails,
                provisioningState,
                lifecycleState,
                scheduledOperations,
                privateEndpointIP,
                privateEndpointLabel,
                ociUri,
                subnetId,
                vnetId,
                createdOn,
                maintenanceBeginOn,
                maintenanceEndOn,
                actualUsedDataStorageSizeInTbs,
                allocatedStorageSizeInTbs,
                apexDetails,
                availableUpgradeVersions?.ToList(),
                connectionStrings,
                connectionUrls,
                dataSafeStatus,
                databaseEdition,
                autonomousDatabaseId,
                inMemoryAreaInGbs,
                nextLongTermBackupCreatedOn,
                longTermBackupSchedule,
                isPreview,
                localAdgAutoFailoverMaxDataLossLimit,
                memoryPerOracleComputeUnitInGbs,
                openMode,
                operationsInsightsStatus,
                permissionLevel,
                privateEndpoint,
                provisionableCpus?.ToList(),
                role,
                serviceConsoleUri,
                sqlWebDeveloperUri,
                supportedRegionsToCloneTo?.ToList(),
                dataGuardRoleChangedOn,
                freeAutonomousDatabaseDeletedOn,
                timeLocalDataGuardEnabled,
                lastFailoverHappenedOn,
                lastRefreshHappenedOn,
                lastRefreshPointTimestamp,
                lastSwitchoverHappenedOn,
                freeAutonomousDatabaseStoppedOn,
                usedDataStorageSizeInGbs,
                usedDataStorageSizeInTbs,
                ocid,
                backupRetentionPeriodInDays,
                whitelistedIPs?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseStandbySummary"/>. </summary>
        /// <param name="lagTimeInSeconds"> The amount of time, in seconds, that the data of the standby database lags the data of the primary database. Can be used to determine the potential data loss in the event of a failover. </param>
        /// <param name="lifecycleState"> The current state of the Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="dataGuardRoleChangedOn"> The date and time the Autonomous Data Guard role was switched for the standby Autonomous Database. </param>
        /// <param name="disasterRecoveryRoleChangedOn"> The date and time the Disaster Recovery role was switched for the standby Autonomous Database. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseStandbySummary"/> instance for mocking. </returns>
        public static AutonomousDatabaseStandbySummary AutonomousDatabaseStandbySummary(int? lagTimeInSeconds = null, AutonomousDatabaseLifecycleState? lifecycleState = null, string lifecycleDetails = null, DateTimeOffset? dataGuardRoleChangedOn = null, DateTimeOffset? disasterRecoveryRoleChangedOn = null)
        {
            return new AutonomousDatabaseStandbySummary(
                lagTimeInSeconds,
                lifecycleState,
                lifecycleDetails,
                dataGuardRoleChangedOn,
                disasterRecoveryRoleChangedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleApexDetailsType"/>. </summary>
        /// <param name="apexVersion"> The Oracle APEX Application Development version. </param>
        /// <param name="ordsVersion"> The Oracle REST Data Services (ORDS) version. </param>
        /// <returns> A new <see cref="Models.OracleApexDetailsType"/> instance for mocking. </returns>
        public static OracleApexDetailsType OracleApexDetailsType(string apexVersion = null, string ordsVersion = null)
        {
            return new OracleApexDetailsType(apexVersion, ordsVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseConnectionStrings"/>. </summary>
        /// <param name="allConnectionStrings"> Returns all connection strings that can be used to connect to the Autonomous Database. </param>
        /// <param name="dedicated"> The database service provides the least level of resources to each SQL statement, but supports the most number of concurrent SQL statements. </param>
        /// <param name="high"> The High database service provides the highest level of resources to each SQL statement resulting in the highest performance, but supports the fewest number of concurrent SQL statements. </param>
        /// <param name="low"> The Low database service provides the least level of resources to each SQL statement, but supports the most number of concurrent SQL statements. </param>
        /// <param name="medium"> The Medium database service provides a lower level of resources to each SQL statement potentially resulting a lower level of performance, but supports more concurrent SQL statements. </param>
        /// <param name="profiles"> A list of connection string profiles to allow clients to group, filter and select connection string values based on structured metadata. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseConnectionStrings"/> instance for mocking. </returns>
        public static AutonomousDatabaseConnectionStrings AutonomousDatabaseConnectionStrings(AutonomousDatabaseConnectionStringType allConnectionStrings = null, string dedicated = null, string high = null, string low = null, string medium = null, IEnumerable<AutonomousDatabaseConnectionStringProfile> profiles = null)
        {
            profiles ??= new List<AutonomousDatabaseConnectionStringProfile>();

            return new AutonomousDatabaseConnectionStrings(
                allConnectionStrings,
                dedicated,
                high,
                low,
                medium,
                profiles?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseConnectionStringType"/>. </summary>
        /// <param name="high"> The High database service provides the highest level of resources to each SQL statement resulting in the highest performance, but supports the fewest number of concurrent SQL statements. </param>
        /// <param name="low"> The Low database service provides the least level of resources to each SQL statement, but supports the most number of concurrent SQL statements. </param>
        /// <param name="medium"> The Medium database service provides a lower level of resources to each SQL statement potentially resulting a lower level of performance, but supports more concurrent SQL statements. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseConnectionStringType"/> instance for mocking. </returns>
        public static AutonomousDatabaseConnectionStringType AutonomousDatabaseConnectionStringType(string high = null, string low = null, string medium = null)
        {
            return new AutonomousDatabaseConnectionStringType(high, low, medium, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseConnectionStringProfile"/>. </summary>
        /// <param name="consumerGroup"> Consumer group used by the connection. </param>
        /// <param name="displayName"> A user-friendly name for the connection. </param>
        /// <param name="hostFormat"> Host format used in connection string. </param>
        /// <param name="isRegional"> True for a regional connection string, applicable to cross-region DG only. </param>
        /// <param name="protocol"> Protocol used by the connection. </param>
        /// <param name="sessionMode"> Specifies whether the listener performs a direct hand-off of the session, or redirects the session. </param>
        /// <param name="syntaxFormat"> Specifies whether the connection string is using the long (LONG), Easy Connect (EZCONNECT), or Easy Connect Plus (EZCONNECTPLUS) format. </param>
        /// <param name="tlsAuthentication"> Specifies whether the TLS handshake is using one-way (SERVER) or mutual (MUTUAL) authentication. </param>
        /// <param name="value"> Connection string value. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseConnectionStringProfile"/> instance for mocking. </returns>
        public static AutonomousDatabaseConnectionStringProfile AutonomousDatabaseConnectionStringProfile(ConnectionConsumerGroup? consumerGroup = null, string displayName = null, ConnectionHostFormatType hostFormat = default, bool? isRegional = null, ConnectionProtocolType protocol = default, ConnectionSessionModeType sessionMode = default, SyntaxFormatType syntaxFormat = default, ConnectionTlsAuthenticationType? tlsAuthentication = null, string value = null)
        {
            return new AutonomousDatabaseConnectionStringProfile(
                consumerGroup,
                displayName,
                hostFormat,
                isRegional,
                protocol,
                sessionMode,
                syntaxFormat,
                tlsAuthentication,
                value,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseConnectionUrls"/>. </summary>
        /// <param name="apexUri"> Oracle Application Express (APEX) URL. </param>
        /// <param name="databaseTransformsUri"> The URL of the Database Transforms for the Autonomous Database. </param>
        /// <param name="graphStudioUri"> The URL of the Graph Studio for the Autonomous Database. </param>
        /// <param name="machineLearningNotebookUri"> The URL of the Oracle Machine Learning (OML) Notebook for the Autonomous Database. </param>
        /// <param name="mongoDBUri"> The URL of the MongoDB API for the Autonomous Database. </param>
        /// <param name="ordsUri"> The Oracle REST Data Services (ORDS) URL of the Web Access for the Autonomous Database. </param>
        /// <param name="sqlDevWebUri"> Oracle SQL Developer Web URL. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseConnectionUrls"/> instance for mocking. </returns>
        public static AutonomousDatabaseConnectionUrls AutonomousDatabaseConnectionUrls(Uri apexUri = null, Uri databaseTransformsUri = null, Uri graphStudioUri = null, Uri machineLearningNotebookUri = null, Uri mongoDBUri = null, Uri ordsUri = null, Uri sqlDevWebUri = null)
        {
            return new AutonomousDatabaseConnectionUrls(
                apexUri,
                databaseTransformsUri,
                graphStudioUri,
                machineLearningNotebookUri,
                mongoDBUri,
                ordsUri,
                sqlDevWebUri,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.CloudExadataInfrastructureData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <param name="zones"> CloudExadataInfrastructure zones. </param>
        /// <returns> A new <see cref="OracleDatabase.CloudExadataInfrastructureData"/> instance for mocking. </returns>
        public static CloudExadataInfrastructureData CloudExadataInfrastructureData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CloudExadataInfrastructureProperties properties = null, IEnumerable<string> zones = null)
        {
            tags ??= new Dictionary<string, string>();
            zones ??= new List<string>();

            return new CloudExadataInfrastructureData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                zones?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudExadataInfrastructureProperties"/>. </summary>
        /// <param name="ocid"> Exadata infra ocid. </param>
        /// <param name="computeCount"> The number of compute servers for the cloud Exadata infrastructure. </param>
        /// <param name="storageCount"> The number of storage servers for the cloud Exadata infrastructure. </param>
        /// <param name="totalStorageSizeInGbs"> The total storage allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </param>
        /// <param name="availableStorageSizeInGbs"> The available storage can be allocated to the cloud Exadata infrastructure resource, in gigabytes (GB). </param>
        /// <param name="createdOn"> The date and time the cloud Exadata infrastructure resource was created. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="maintenanceWindow"> maintenanceWindow property. </param>
        /// <param name="estimatedPatchingTime"> The estimated total time required in minutes for all patching operations (database server, storage server, and network switch patching). </param>
        /// <param name="customerContacts"> The list of customer email addresses that receive information from Oracle about the specified OCI Database service resource. Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators. Up to 10 email addresses can be added to the customer contacts for a cloud Exadata infrastructure instance. </param>
        /// <param name="provisioningState"> CloudExadataInfrastructure provisioning state. </param>
        /// <param name="lifecycleState"> CloudExadataInfrastructure lifecycle state. </param>
        /// <param name="shape"> The model name of the cloud Exadata infrastructure resource. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="cpuCount"> The total number of CPU cores allocated. </param>
        /// <param name="maxCpuCount"> The total number of CPU cores available. </param>
        /// <param name="memorySizeInGbs"> The memory allocated in GBs. </param>
        /// <param name="maxMemoryInGbs"> The total memory available in GBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The local node storage to be allocated in GBs. </param>
        /// <param name="maxDBNodeStorageSizeInGbs"> The total local node storage available in GBs. </param>
        /// <param name="dataStorageSizeInTbs"> The quantity of data in the database, in terabytes. </param>
        /// <param name="maxDataStorageInTbs"> The total available DATA disk group size. </param>
        /// <param name="dbServerVersion"> The software version of the database servers (dom0) in the Exadata infrastructure. </param>
        /// <param name="storageServerVersion"> The software version of the storage servers (cells) in the Exadata infrastructure. </param>
        /// <param name="activatedStorageCount"> The requested number of additional storage servers activated for the Exadata infrastructure. </param>
        /// <param name="additionalStorageCount"> The requested number of additional storage servers for the Exadata infrastructure. </param>
        /// <param name="displayName"> The name for the Exadata infrastructure. </param>
        /// <param name="lastMaintenanceRunId"> The OCID of the last maintenance run. </param>
        /// <param name="nextMaintenanceRunId"> The OCID of the next maintenance run. </param>
        /// <param name="monthlyDBServerVersion"> Monthly Db Server version. </param>
        /// <param name="monthlyStorageServerVersion"> Monthly Storage Server version. </param>
        /// <returns> A new <see cref="Models.CloudExadataInfrastructureProperties"/> instance for mocking. </returns>
        public static CloudExadataInfrastructureProperties CloudExadataInfrastructureProperties(ResourceIdentifier ocid = null, int? computeCount = null, int? storageCount = null, int? totalStorageSizeInGbs = null, int? availableStorageSizeInGbs = null, DateTimeOffset? createdOn = null, string lifecycleDetails = null, OracleDatabaseMaintenanceWindow maintenanceWindow = null, EstimatedPatchingTime estimatedPatchingTime = null, IEnumerable<OracleCustomerContact> customerContacts = null, OracleDatabaseProvisioningState? provisioningState = null, CloudExadataInfrastructureLifecycleState? lifecycleState = null, string shape = null, Uri ociUri = null, int? cpuCount = null, int? maxCpuCount = null, int? memorySizeInGbs = null, int? maxMemoryInGbs = null, int? dbNodeStorageSizeInGbs = null, int? maxDBNodeStorageSizeInGbs = null, double? dataStorageSizeInTbs = null, double? maxDataStorageInTbs = null, string dbServerVersion = null, string storageServerVersion = null, int? activatedStorageCount = null, int? additionalStorageCount = null, string displayName = null, ResourceIdentifier lastMaintenanceRunId = null, ResourceIdentifier nextMaintenanceRunId = null, string monthlyDBServerVersion = null, string monthlyStorageServerVersion = null)
        {
            customerContacts ??= new List<OracleCustomerContact>();

            return new CloudExadataInfrastructureProperties(
                ocid,
                computeCount,
                storageCount,
                totalStorageSizeInGbs,
                availableStorageSizeInGbs,
                createdOn,
                lifecycleDetails,
                maintenanceWindow,
                estimatedPatchingTime,
                customerContacts?.ToList(),
                provisioningState,
                lifecycleState,
                shape,
                ociUri,
                cpuCount,
                maxCpuCount,
                memorySizeInGbs,
                maxMemoryInGbs,
                dbNodeStorageSizeInGbs,
                maxDBNodeStorageSizeInGbs,
                dataStorageSizeInTbs,
                maxDataStorageInTbs,
                dbServerVersion,
                storageServerVersion,
                activatedStorageCount,
                additionalStorageCount,
                displayName,
                lastMaintenanceRunId,
                nextMaintenanceRunId,
                monthlyDBServerVersion,
                monthlyStorageServerVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EstimatedPatchingTime"/>. </summary>
        /// <param name="estimatedDBServerPatchingTime"> The estimated time required in minutes for database server patching. </param>
        /// <param name="estimatedNetworkSwitchesPatchingTime"> The estimated time required in minutes for network switch patching. </param>
        /// <param name="estimatedStorageServerPatchingTime"> The estimated time required in minutes for storage server patching. </param>
        /// <param name="totalEstimatedPatchingTime"> The estimated total time required in minutes for all patching operations. </param>
        /// <returns> A new <see cref="Models.EstimatedPatchingTime"/> instance for mocking. </returns>
        public static EstimatedPatchingTime EstimatedPatchingTime(int? estimatedDBServerPatchingTime = null, int? estimatedNetworkSwitchesPatchingTime = null, int? estimatedStorageServerPatchingTime = null, int? totalEstimatedPatchingTime = null)
        {
            return new EstimatedPatchingTime(estimatedDBServerPatchingTime, estimatedNetworkSwitchesPatchingTime, estimatedStorageServerPatchingTime, totalEstimatedPatchingTime, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.CloudVmClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.CloudVmClusterData"/> instance for mocking. </returns>
        public static CloudVmClusterData CloudVmClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, CloudVmClusterProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new CloudVmClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudVmClusterProperties"/>. </summary>
        /// <param name="ocid"> Cloud VM Cluster ocid. </param>
        /// <param name="listenerPort"> The port number configured for the listener on the cloud VM cluster. </param>
        /// <param name="nodeCount"> The number of nodes in the cloud VM cluster. </param>
        /// <param name="storageSizeInGbs"> The data disk group size to be allocated in GBs per VM. </param>
        /// <param name="dataStorageSizeInTbs"> The data disk group size to be allocated in TBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The local node storage to be allocated in GBs. </param>
        /// <param name="memorySizeInGbs"> The memory to be allocated in GBs. </param>
        /// <param name="createdOn"> The date and time that the cloud VM cluster was created. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="timeZone"> The time zone of the cloud VM cluster. For details, see [Exadata Infrastructure Time Zones](/Content/Database/References/timezones.htm). </param>
        /// <param name="zoneId"> The OCID of the zone the cloud VM cluster is associated with. </param>
        /// <param name="hostname"> The hostname for the cloud VM cluster. </param>
        /// <param name="domain"> The domain name for the cloud VM cluster. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores enabled on the cloud VM cluster. </param>
        /// <param name="ocpuCount"> The number of OCPU cores to enable on the cloud VM cluster. Only 1 decimal place is allowed for the fractional part. </param>
        /// <param name="clusterName"> The cluster name for cloud VM cluster. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive. </param>
        /// <param name="dataStoragePercentage"> The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 35, 40, 60 and 80. The default is 80 percent assigned to DATA storage. See [Storage Configuration](/Content/Database/Concepts/exaoverview.htm#Exadata) in the Exadata documentation for details on the impact of the configuration settings on storage. </param>
        /// <param name="isLocalBackupEnabled"> If true, database backup on local Exadata storage is configured for the cloud VM cluster. If false, database backup on local Exadata storage is not available in the cloud VM cluster. </param>
        /// <param name="cloudExadataInfrastructureId"> Cloud Exadata Infrastructure ID. </param>
        /// <param name="isSparseDiskgroupEnabled"> If true, sparse disk group is configured for the cloud VM cluster. If false, sparse disk group is not created. </param>
        /// <param name="systemVersion"> Operating system version of the image. </param>
        /// <param name="sshPublicKeys"> The public key portion of one or more key pairs used for SSH access to the cloud VM cluster. </param>
        /// <param name="licenseModel"> The Oracle license model that applies to the cloud VM cluster. The default is LICENSE_INCLUDED. </param>
        /// <param name="diskRedundancy"> The type of redundancy configured for the cloud Vm cluster. NORMAL is 2-way redundancy. HIGH is 3-way redundancy. </param>
        /// <param name="scanIPIds"> The Single Client Access Name (SCAN) IP addresses associated with the cloud VM cluster. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster. **Note:** For a single-node DB system, this list is empty. </param>
        /// <param name="vipIds"> The virtual IP (VIP) addresses associated with the cloud VM cluster. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the Exadata Cloud Service instance to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster. **Note:** For a single-node DB system, this list is empty. </param>
        /// <param name="scanDnsName"> The FQDN of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster. </param>
        /// <param name="scanListenerPortTcp"> The TCP Single Client Access Name (SCAN) port. The default port is 1521. </param>
        /// <param name="scanListenerPortTcpSsl"> The TCPS Single Client Access Name (SCAN) port. The default port is 2484. </param>
        /// <param name="scanDnsRecordId"> The OCID of the DNS record for the SCAN IP addresses that are associated with the cloud VM cluster. </param>
        /// <param name="shape"> The model name of the Exadata hardware running the cloud VM cluster. </param>
        /// <param name="provisioningState"> CloudVmCluster provisioning state. </param>
        /// <param name="lifecycleState"> CloudVmCluster lifecycle state. </param>
        /// <param name="vnetId"> VNET for network connectivity. </param>
        /// <param name="giVersion"> Oracle Grid Infrastructure (GI) software version. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="nsgUri"> HTTPS link to OCI Network Security Group exposed to Azure Customer via the Azure Interface. </param>
        /// <param name="subnetId"> Client subnet. </param>
        /// <param name="backupSubnetCidr"> Client OCI backup subnet CIDR, default is 192.168.252.0/22. </param>
        /// <param name="nsgCidrs"> CIDR blocks for additional NSG ingress rules. The VNET CIDRs used to provision the VM Cluster will be added by default. </param>
        /// <param name="dataCollectionOptions"> Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS. </param>
        /// <param name="displayName"> Display Name. </param>
        /// <param name="computeNodes"> The list of compute servers to be added to the cloud VM cluster. </param>
        /// <param name="iormConfigCache"> iormConfigCache details for cloud VM cluster. </param>
        /// <param name="lastUpdateHistoryEntryId"> The OCID of the last maintenance update history entry. </param>
        /// <param name="dbServers"> The list of DB servers. </param>
        /// <param name="compartmentId"> Cluster compartmentId. </param>
        /// <param name="subnetOcid"> Cluster subnet ocid. </param>
        /// <returns> A new <see cref="Models.CloudVmClusterProperties"/> instance for mocking. </returns>
        public static CloudVmClusterProperties CloudVmClusterProperties(ResourceIdentifier ocid = null, long? listenerPort = null, int? nodeCount = null, int? storageSizeInGbs = null, double? dataStorageSizeInTbs = null, int? dbNodeStorageSizeInGbs = null, int? memorySizeInGbs = null, DateTimeOffset? createdOn = null, string lifecycleDetails = null, string timeZone = null, ResourceIdentifier zoneId = null, string hostname = null, string domain = null, int cpuCoreCount = default, float? ocpuCount = null, string clusterName = null, int? dataStoragePercentage = null, bool? isLocalBackupEnabled = null, ResourceIdentifier cloudExadataInfrastructureId = null, bool? isSparseDiskgroupEnabled = null, string systemVersion = null, IEnumerable<string> sshPublicKeys = null, OracleLicenseModel? licenseModel = null, CloudVmClusterDiskRedundancy? diskRedundancy = null, IEnumerable<string> scanIPIds = null, IEnumerable<string> vipIds = null, string scanDnsName = null, int? scanListenerPortTcp = null, int? scanListenerPortTcpSsl = null, ResourceIdentifier scanDnsRecordId = null, string shape = null, OracleDatabaseProvisioningState? provisioningState = null, CloudVmClusterLifecycleState? lifecycleState = null, ResourceIdentifier vnetId = null, string giVersion = null, Uri ociUri = null, Uri nsgUri = null, ResourceIdentifier subnetId = null, string backupSubnetCidr = null, IEnumerable<CloudVmClusterNsgCidr> nsgCidrs = null, DiagnosticCollectionConfig dataCollectionOptions = null, string displayName = null, IEnumerable<ResourceIdentifier> computeNodes = null, ExadataIormConfig iormConfigCache = null, ResourceIdentifier lastUpdateHistoryEntryId = null, IEnumerable<ResourceIdentifier> dbServers = null, ResourceIdentifier compartmentId = null, ResourceIdentifier subnetOcid = null)
        {
            sshPublicKeys ??= new List<string>();
            scanIPIds ??= new List<string>();
            vipIds ??= new List<string>();
            nsgCidrs ??= new List<CloudVmClusterNsgCidr>();
            computeNodes ??= new List<ResourceIdentifier>();
            dbServers ??= new List<ResourceIdentifier>();

            return new CloudVmClusterProperties(
                ocid,
                listenerPort,
                nodeCount,
                storageSizeInGbs,
                dataStorageSizeInTbs,
                dbNodeStorageSizeInGbs,
                memorySizeInGbs,
                createdOn,
                lifecycleDetails,
                timeZone,
                zoneId,
                hostname,
                domain,
                cpuCoreCount,
                ocpuCount,
                clusterName,
                dataStoragePercentage,
                isLocalBackupEnabled,
                cloudExadataInfrastructureId,
                isSparseDiskgroupEnabled,
                systemVersion,
                sshPublicKeys?.ToList(),
                licenseModel,
                diskRedundancy,
                scanIPIds?.ToList(),
                vipIds?.ToList(),
                scanDnsName,
                scanListenerPortTcp,
                scanListenerPortTcpSsl,
                scanDnsRecordId,
                shape,
                provisioningState,
                lifecycleState,
                vnetId,
                giVersion,
                ociUri,
                nsgUri,
                subnetId,
                backupSubnetCidr,
                nsgCidrs?.ToList(),
                dataCollectionOptions,
                displayName,
                computeNodes?.ToList(),
                iormConfigCache,
                lastUpdateHistoryEntryId,
                dbServers?.ToList(),
                compartmentId,
                subnetOcid,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExadataIormConfig"/>. </summary>
        /// <param name="dbPlans"> An array of IORM settings for all the database in the Exadata DB system. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycleState. </param>
        /// <param name="lifecycleState"> The current state of IORM configuration for the Exadata DB system. </param>
        /// <param name="objective"> The current value for the IORM objective. The default is AUTO. </param>
        /// <returns> A new <see cref="Models.ExadataIormConfig"/> instance for mocking. </returns>
        public static ExadataIormConfig ExadataIormConfig(IEnumerable<DBIormConfig> dbPlans = null, string lifecycleDetails = null, IormLifecycleState? lifecycleState = null, IormObjective? objective = null)
        {
            dbPlans ??= new List<DBIormConfig>();

            return new ExadataIormConfig(dbPlans?.ToList(), lifecycleDetails, lifecycleState, objective, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DBIormConfig"/>. </summary>
        /// <param name="dbName"> The database name. For the default DbPlan, the dbName is default. </param>
        /// <param name="flashCacheLimit"> The flash cache limit for this database. This value is internally configured based on the share value assigned to the database. </param>
        /// <param name="share"> The relative priority of this database. </param>
        /// <returns> A new <see cref="Models.DBIormConfig"/> instance for mocking. </returns>
        public static DBIormConfig DBIormConfig(string dbName = null, string flashCacheLimit = null, int? share = null)
        {
            return new DBIormConfig(dbName, flashCacheLimit, share, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.AutonomousDatabaseCharacterSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="autonomousDatabaseCharacterSet"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.AutonomousDatabaseCharacterSetData"/> instance for mocking. </returns>
        public static AutonomousDatabaseCharacterSetData AutonomousDatabaseCharacterSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string autonomousDatabaseCharacterSet = null)
        {
            return new AutonomousDatabaseCharacterSetData(
                id,
                name,
                resourceType,
                systemData,
                autonomousDatabaseCharacterSet != null ? new AutonomousDatabaseCharacterSetProperties(autonomousDatabaseCharacterSet, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.AutonomousDatabaseNationalCharacterSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="autonomousDatabaseNationalCharacterSet"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.AutonomousDatabaseNationalCharacterSetData"/> instance for mocking. </returns>
        public static AutonomousDatabaseNationalCharacterSetData AutonomousDatabaseNationalCharacterSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string autonomousDatabaseNationalCharacterSet = null)
        {
            return new AutonomousDatabaseNationalCharacterSetData(
                id,
                name,
                resourceType,
                systemData,
                autonomousDatabaseNationalCharacterSet != null ? new AutonomousDatabaseNationalCharacterSetProperties(autonomousDatabaseNationalCharacterSet, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.AutonomousDBVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.AutonomousDBVersionData"/> instance for mocking. </returns>
        public static AutonomousDBVersionData AutonomousDBVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AutonomousDBVersionProperties properties = null)
        {
            return new AutonomousDBVersionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDBVersionProperties"/>. </summary>
        /// <param name="version"> Supported Autonomous Db versions. </param>
        /// <param name="dbWorkload"> The Autonomous Database workload type. </param>
        /// <param name="isDefaultForFree"> True if this version of the Oracle Database software's default is free. </param>
        /// <param name="isDefaultForPaid"> True if this version of the Oracle Database software's default is paid. </param>
        /// <param name="isFreeTierEnabled"> True if this version of the Oracle Database software can be used for Always-Free Autonomous Databases. </param>
        /// <param name="isPaidEnabled"> True if this version of the Oracle Database software has payments enabled. </param>
        /// <returns> A new <see cref="Models.AutonomousDBVersionProperties"/> instance for mocking. </returns>
        public static AutonomousDBVersionProperties AutonomousDBVersionProperties(string version = null, AutonomousDatabaseWorkloadType? dbWorkload = null, bool? isDefaultForFree = null, bool? isDefaultForPaid = null, bool? isFreeTierEnabled = null, bool? isPaidEnabled = null)
        {
            return new AutonomousDBVersionProperties(
                version,
                dbWorkload,
                isDefaultForFree,
                isDefaultForPaid,
                isFreeTierEnabled,
                isPaidEnabled,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleDBSystemShapeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleDBSystemShapeData"/> instance for mocking. </returns>
        public static OracleDBSystemShapeData OracleDBSystemShapeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OracleDBSystemShapeProperties properties = null)
        {
            return new OracleDBSystemShapeData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleDBSystemShapeProperties"/>. </summary>
        /// <param name="shapeFamily"> The family of the shape used for the DB system. </param>
        /// <param name="availableCoreCount"> The maximum number of CPU cores that can be enabled on the DB system for this shape. </param>
        /// <param name="minimumCoreCount"> The minimum number of CPU cores that can be enabled on the DB system for this shape. </param>
        /// <param name="runtimeMinimumCoreCount"> The runtime minimum number of CPU cores that can be enabled on the DB system for this shape. </param>
        /// <param name="coreCountIncrement"> The discrete number by which the CPU core count for this shape can be increased or decreased. </param>
        /// <param name="minStorageCount"> The minimum number of Exadata storage servers available for the Exadata infrastructure. </param>
        /// <param name="maxStorageCount"> The maximum number of Exadata storage servers available for the Exadata infrastructure. </param>
        /// <param name="availableDataStoragePerServerInTbs"> The maximum data storage available per storage server for this shape. Only applicable to ExaCC Elastic shapes. </param>
        /// <param name="availableMemoryPerNodeInGbs"> The maximum memory available per database node for this shape. Only applicable to ExaCC Elastic shapes. </param>
        /// <param name="availableDBNodePerNodeInGbs"> The maximum Db Node storage available per database node for this shape. Only applicable to ExaCC Elastic shapes. </param>
        /// <param name="minCoreCountPerNode"> The minimum number of CPU cores that can be enabled per node for this shape. </param>
        /// <param name="availableMemoryInGbs"> The maximum memory that can be enabled for this shape. </param>
        /// <param name="minMemoryPerNodeInGbs"> The minimum memory that need be allocated per node for this shape. </param>
        /// <param name="availableDBNodeStorageInGbs"> The maximum Db Node storage that can be enabled for this shape. </param>
        /// <param name="minDBNodeStoragePerNodeInGbs"> The minimum Db Node storage that need be allocated per node for this shape. </param>
        /// <param name="availableDataStorageInTbs"> The maximum DATA storage that can be enabled for this shape. </param>
        /// <param name="minDataStorageInTbs"> The minimum data storage that need be allocated for this shape. </param>
        /// <param name="minimumNodeCount"> The minimum number of database nodes available for this shape. </param>
        /// <param name="maximumNodeCount"> The maximum number of database nodes available for this shape. </param>
        /// <param name="availableCoreCountPerNode"> The maximum number of CPU cores per database node that can be enabled for this shape. Only applicable to the flex Exadata shape and ExaCC Elastic shapes. </param>
        /// <returns> A new <see cref="Models.OracleDBSystemShapeProperties"/> instance for mocking. </returns>
        public static OracleDBSystemShapeProperties OracleDBSystemShapeProperties(string shapeFamily = null, int availableCoreCount = default, int? minimumCoreCount = null, int? runtimeMinimumCoreCount = null, int? coreCountIncrement = null, int? minStorageCount = null, int? maxStorageCount = null, double? availableDataStoragePerServerInTbs = null, int? availableMemoryPerNodeInGbs = null, int? availableDBNodePerNodeInGbs = null, int? minCoreCountPerNode = null, int? availableMemoryInGbs = null, int? minMemoryPerNodeInGbs = null, int? availableDBNodeStorageInGbs = null, int? minDBNodeStoragePerNodeInGbs = null, int? availableDataStorageInTbs = null, int? minDataStorageInTbs = null, int? minimumNodeCount = null, int? maximumNodeCount = null, int? availableCoreCountPerNode = null)
        {
            return new OracleDBSystemShapeProperties(
                shapeFamily,
                availableCoreCount,
                minimumCoreCount,
                runtimeMinimumCoreCount,
                coreCountIncrement,
                minStorageCount,
                maxStorageCount,
                availableDataStoragePerServerInTbs,
                availableMemoryPerNodeInGbs,
                availableDBNodePerNodeInGbs,
                minCoreCountPerNode,
                availableMemoryInGbs,
                minMemoryPerNodeInGbs,
                availableDBNodeStorageInGbs,
                minDBNodeStoragePerNodeInGbs,
                availableDataStorageInTbs,
                minDataStorageInTbs,
                minimumNodeCount,
                maximumNodeCount,
                availableCoreCountPerNode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleDnsPrivateViewData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleDnsPrivateViewData"/> instance for mocking. </returns>
        public static OracleDnsPrivateViewData OracleDnsPrivateViewData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OracleDnsPrivateViewProperties properties = null)
        {
            return new OracleDnsPrivateViewData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleDnsPrivateViewProperties"/>. </summary>
        /// <param name="ocid"> The OCID of the view. </param>
        /// <param name="displayName"> The display name of the view resource. </param>
        /// <param name="isProtected"> A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed. </param>
        /// <param name="lifecycleState"> Views lifecycleState. </param>
        /// <param name="self"> The canonical absolute URL of the resource. </param>
        /// <param name="createdOn"> views timeCreated. </param>
        /// <param name="updatedOn"> views timeCreated. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <returns> A new <see cref="Models.OracleDnsPrivateViewProperties"/> instance for mocking. </returns>
        public static OracleDnsPrivateViewProperties OracleDnsPrivateViewProperties(ResourceIdentifier ocid = null, string displayName = null, bool isProtected = default, DnsPrivateViewsLifecycleState? lifecycleState = null, string self = null, DateTimeOffset createdOn = default, DateTimeOffset updatedOn = default, OracleDatabaseResourceProvisioningState? provisioningState = null)
        {
            return new OracleDnsPrivateViewProperties(
                ocid,
                displayName,
                isProtected,
                lifecycleState,
                self,
                createdOn,
                updatedOn,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleDnsPrivateZoneData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleDnsPrivateZoneData"/> instance for mocking. </returns>
        public static OracleDnsPrivateZoneData OracleDnsPrivateZoneData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OracleDnsPrivateZoneProperties properties = null)
        {
            return new OracleDnsPrivateZoneData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleDnsPrivateZoneProperties"/>. </summary>
        /// <param name="ocid"> The OCID of the Zone. </param>
        /// <param name="isProtected"> A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed. </param>
        /// <param name="lifecycleState"> Zones lifecycleState. </param>
        /// <param name="self"> The canonical absolute URL of the resource. </param>
        /// <param name="serial"> The current serial of the zone. As seen in the zone's SOA record. </param>
        /// <param name="version"> Version is the never-repeating, totally-orderable, version of the zone, from which the serial field of the zone's SOA record is derived. </param>
        /// <param name="viewId"> The OCID of the private view containing the zone. This value will be null for zones in the global DNS, which are publicly resolvable and not part of a private view. </param>
        /// <param name="zoneType"> The type of the zone. Must be either PRIMARY or SECONDARY. SECONDARY is only supported for GLOBAL zones. </param>
        /// <param name="createdOn"> Zones timeCreated. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <returns> A new <see cref="Models.OracleDnsPrivateZoneProperties"/> instance for mocking. </returns>
        public static OracleDnsPrivateZoneProperties OracleDnsPrivateZoneProperties(ResourceIdentifier ocid = null, bool isProtected = default, DnsPrivateZonesLifecycleState? lifecycleState = null, string self = null, int serial = default, string version = null, ResourceIdentifier viewId = null, OracleDnsPrivateZoneType zoneType = default, DateTimeOffset createdOn = default, OracleDatabaseResourceProvisioningState? provisioningState = null)
        {
            return new OracleDnsPrivateZoneProperties(
                ocid,
                isProtected,
                lifecycleState,
                self,
                serial,
                version,
                viewId,
                zoneType,
                createdOn,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleGIVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="oracleGIVersion"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleGIVersionData"/> instance for mocking. </returns>
        public static OracleGIVersionData OracleGIVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string oracleGIVersion = null)
        {
            return new OracleGIVersionData(
                id,
                name,
                resourceType,
                systemData,
                oracleGIVersion != null ? new OracleGIVersionProperties(oracleGIVersion, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleSystemVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="oracleSystemVersion"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleSystemVersionData"/> instance for mocking. </returns>
        public static OracleSystemVersionData OracleSystemVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string oracleSystemVersion = null)
        {
            return new OracleSystemVersionData(
                id,
                name,
                resourceType,
                systemData,
                oracleSystemVersion != null ? new OracleSystemVersionProperties(oracleSystemVersion, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <param name="plan"> Details of the resource plan. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleSubscriptionData"/> instance for mocking. </returns>
        public static OracleSubscriptionData OracleSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OracleSubscriptionProperties properties = null, ArmPlan plan = null)
        {
            return new OracleSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                plan,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleSubscriptionProperties"/>. </summary>
        /// <param name="provisioningState"> OracleSubscriptionProvisioningState provisioning state. </param>
        /// <param name="saasSubscriptionId"> SAAS subscription ID generated by Marketplace. </param>
        /// <param name="cloudAccountId"> Cloud Account Id. </param>
        /// <param name="cloudAccountState"> Cloud Account provisioning state. </param>
        /// <param name="termUnit"> Term Unit. P1Y, P3Y, etc, see Durations https://en.wikipedia.org/wiki/ISO_8601. </param>
        /// <param name="productCode"> Product code for the term unit. </param>
        /// <param name="intent"> Intent for the update operation. </param>
        /// <returns> A new <see cref="Models.OracleSubscriptionProperties"/> instance for mocking. </returns>
        public static OracleSubscriptionProperties OracleSubscriptionProperties(OracleSubscriptionProvisioningState? provisioningState = null, string saasSubscriptionId = null, ResourceIdentifier cloudAccountId = null, CloudAccountProvisioningState? cloudAccountState = null, string termUnit = null, string productCode = null, OracleSubscriptionUpdateIntent? intent = null)
        {
            return new OracleSubscriptionProperties(
                provisioningState,
                saasSubscriptionId,
                cloudAccountId,
                cloudAccountState,
                termUnit,
                productCode,
                intent,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudAccountActivationLinks"/>. </summary>
        /// <param name="newCloudAccountActivationLink"> New Cloud Account Activation Link. </param>
        /// <param name="existingCloudAccountActivationLink"> Existing Cloud Account Activation Link. </param>
        /// <returns> A new <see cref="Models.CloudAccountActivationLinks"/> instance for mocking. </returns>
        public static CloudAccountActivationLinks CloudAccountActivationLinks(string newCloudAccountActivationLink = null, string existingCloudAccountActivationLink = null)
        {
            return new CloudAccountActivationLinks(newCloudAccountActivationLink, existingCloudAccountActivationLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudAccountDetails"/>. </summary>
        /// <param name="cloudAccountName"> Cloud Account name. </param>
        /// <param name="cloudAccountHomeRegion"> Cloud Account Home region. </param>
        /// <returns> A new <see cref="Models.CloudAccountDetails"/> instance for mocking. </returns>
        public static CloudAccountDetails CloudAccountDetails(string cloudAccountName = null, string cloudAccountHomeRegion = null)
        {
            return new CloudAccountDetails(cloudAccountName, cloudAccountHomeRegion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SaasSubscriptionDetails"/>. </summary>
        /// <param name="id"> Purchased SaaS subscription ID. </param>
        /// <param name="subscriptionName"> SaaS subscription name. </param>
        /// <param name="createdOn"> Creation Date and Time. </param>
        /// <param name="offerId"> Purchased offer ID. </param>
        /// <param name="planId"> Purchased offer's plan ID. </param>
        /// <param name="saasSubscriptionStatus"> Indicates the status of the Subscription. </param>
        /// <param name="publisherId"> Publisher ID. </param>
        /// <param name="purchaserEmailId"> Purchaser Email ID. </param>
        /// <param name="purchaserTenantId"> Purchaser Tenant ID. </param>
        /// <param name="termUnit"> Purchase Term Unit. </param>
        /// <param name="isAutoRenew"> AutoRenew flag. </param>
        /// <param name="isFreeTrial"> FreeTrial flag. </param>
        /// <returns> A new <see cref="Models.SaasSubscriptionDetails"/> instance for mocking. </returns>
        public static SaasSubscriptionDetails SaasSubscriptionDetails(string id = null, string subscriptionName = null, DateTimeOffset? createdOn = null, string offerId = null, string planId = null, string saasSubscriptionStatus = null, string publisherId = null, string purchaserEmailId = null, string purchaserTenantId = null, string termUnit = null, bool? isAutoRenew = null, bool? isFreeTrial = null)
        {
            return new SaasSubscriptionDetails(
                id,
                subscriptionName,
                createdOn,
                offerId,
                planId,
                saasSubscriptionStatus,
                publisherId,
                purchaserEmailId,
                purchaserTenantId,
                termUnit,
                isAutoRenew,
                isFreeTrial,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.AutonomousDatabaseBackupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.AutonomousDatabaseBackupData"/> instance for mocking. </returns>
        public static AutonomousDatabaseBackupData AutonomousDatabaseBackupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AutonomousDatabaseBackupProperties properties = null)
        {
            return new AutonomousDatabaseBackupData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseBackupProperties"/>. </summary>
        /// <param name="autonomousDatabaseOcid"> The OCID of the Autonomous Database. </param>
        /// <param name="databaseSizeInTbs"> The size of the database in terabytes at the time the backup was taken. </param>
        /// <param name="dbVersion"> A valid Oracle Database version for Autonomous Database. </param>
        /// <param name="displayName"> The user-friendly name for the backup. The name does not have to be unique. </param>
        /// <param name="ocid"> The OCID of the Autonomous Database backup. </param>
        /// <param name="isAutomatic"> Indicates whether the backup is user-initiated or automatic. </param>
        /// <param name="isRestorable"> Indicates whether the backup can be used to restore the associated Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="lifecycleState"> The current state of the backup. </param>
        /// <param name="retentionPeriodInDays"> Retention period, in days, for long-term backups. </param>
        /// <param name="sizeInTbs"> The backup size in terabytes (TB). </param>
        /// <param name="timeAvailableTil"> Timestamp until when the backup will be available. </param>
        /// <param name="timeStarted"> The date and time the backup started. </param>
        /// <param name="timeEnded"> The date and time the backup completed. </param>
        /// <param name="backupType"> The type of backup. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseBackupProperties"/> instance for mocking. </returns>
        public static AutonomousDatabaseBackupProperties AutonomousDatabaseBackupProperties(ResourceIdentifier autonomousDatabaseOcid = null, double? databaseSizeInTbs = null, string dbVersion = null, string displayName = null, ResourceIdentifier ocid = null, bool? isAutomatic = null, bool? isRestorable = null, string lifecycleDetails = null, AutonomousDatabaseBackupLifecycleState? lifecycleState = null, int? retentionPeriodInDays = null, double? sizeInTbs = null, DateTimeOffset? timeAvailableTil = null, string timeStarted = null, string timeEnded = null, AutonomousDatabaseBackupType? backupType = null, OracleDatabaseProvisioningState? provisioningState = null)
        {
            return new AutonomousDatabaseBackupProperties(
                autonomousDatabaseOcid,
                databaseSizeInTbs,
                dbVersion,
                displayName,
                ocid,
                isAutomatic,
                isRestorable,
                lifecycleDetails,
                lifecycleState,
                retentionPeriodInDays,
                sizeInTbs,
                timeAvailableTil,
                timeStarted,
                timeEnded,
                backupType,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GenerateAutonomousDatabaseWalletDetails"/>. </summary>
        /// <param name="generateType"> The type of wallet to generate. </param>
        /// <param name="isRegional"> True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only. </param>
        /// <param name="password"> The password to encrypt the keys inside the wallet. </param>
        /// <returns> A new <see cref="Models.GenerateAutonomousDatabaseWalletDetails"/> instance for mocking. </returns>
        public static GenerateAutonomousDatabaseWalletDetails GenerateAutonomousDatabaseWalletDetails(WalletGenerateType? generateType = null, bool? isRegional = null, string password = null)
        {
            return new GenerateAutonomousDatabaseWalletDetails(generateType, isRegional, password, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseWalletFile"/>. </summary>
        /// <param name="walletFiles"> The base64 encoded wallet files. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseWalletFile"/> instance for mocking. </returns>
        public static AutonomousDatabaseWalletFile AutonomousDatabaseWalletFile(string walletFiles = null)
        {
            return new AutonomousDatabaseWalletFile(walletFiles, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.OracleDBServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.OracleDBServerData"/> instance for mocking. </returns>
        public static OracleDBServerData OracleDBServerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OracleDBServerProperties properties = null)
        {
            return new OracleDBServerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleDBServerProperties"/>. </summary>
        /// <param name="ocid"> Db server name. </param>
        /// <param name="displayName"> The name for the Db Server. </param>
        /// <param name="compartmentId"> The OCID of the compartment. </param>
        /// <param name="exadataInfrastructureId"> The OCID of the Exadata infrastructure. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores enabled on the Db server. </param>
        /// <param name="dbServerPatchingDetails"> dbServerPatching details of the Db server. </param>
        /// <param name="maxMemoryInGbs"> The total memory available in GBs. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The allocated local node storage in GBs on the Db server. </param>
        /// <param name="vmClusterIds"> The OCID of the VM Clusters associated with the Db server. </param>
        /// <param name="dbNodeIds"> The OCID of the Db nodes associated with the Db server. </param>
        /// <param name="lifecycleDetails"> Lifecycle details of dbServer. </param>
        /// <param name="lifecycleState"> DbServer provisioning state. </param>
        /// <param name="maxCpuCount"> The total number of CPU cores available. </param>
        /// <param name="autonomousVmClusterIds"> The list of OCIDs of the Autonomous VM Clusters associated with the Db server. </param>
        /// <param name="autonomousVirtualMachineIds"> The list of OCIDs of the Autonomous Virtual Machines associated with the Db server. </param>
        /// <param name="maxDBNodeStorageInGbs"> The total max dbNode storage in GBs. </param>
        /// <param name="memorySizeInGbs"> The total memory size in GBs. </param>
        /// <param name="shape"> The shape of the Db server. The shape determines the amount of CPU, storage, and memory resources available. </param>
        /// <param name="createdOn"> The date and time that the Db Server was created. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <returns> A new <see cref="Models.OracleDBServerProperties"/> instance for mocking. </returns>
        public static OracleDBServerProperties OracleDBServerProperties(ResourceIdentifier ocid = null, string displayName = null, ResourceIdentifier compartmentId = null, ResourceIdentifier exadataInfrastructureId = null, int? cpuCoreCount = null, DBServerPatchingDetails dbServerPatchingDetails = null, int? maxMemoryInGbs = null, int? dbNodeStorageSizeInGbs = null, IEnumerable<ResourceIdentifier> vmClusterIds = null, IEnumerable<ResourceIdentifier> dbNodeIds = null, string lifecycleDetails = null, DBServerProvisioningState? lifecycleState = null, int? maxCpuCount = null, IEnumerable<ResourceIdentifier> autonomousVmClusterIds = null, IEnumerable<ResourceIdentifier> autonomousVirtualMachineIds = null, int? maxDBNodeStorageInGbs = null, int? memorySizeInGbs = null, string shape = null, DateTimeOffset? createdOn = null, OracleDatabaseResourceProvisioningState? provisioningState = null)
        {
            vmClusterIds ??= new List<ResourceIdentifier>();
            dbNodeIds ??= new List<ResourceIdentifier>();
            autonomousVmClusterIds ??= new List<ResourceIdentifier>();
            autonomousVirtualMachineIds ??= new List<ResourceIdentifier>();

            return new OracleDBServerProperties(
                ocid,
                displayName,
                compartmentId,
                exadataInfrastructureId,
                cpuCoreCount,
                dbServerPatchingDetails,
                maxMemoryInGbs,
                dbNodeStorageSizeInGbs,
                vmClusterIds?.ToList(),
                dbNodeIds?.ToList(),
                lifecycleDetails,
                lifecycleState,
                maxCpuCount,
                autonomousVmClusterIds?.ToList(),
                autonomousVirtualMachineIds?.ToList(),
                maxDBNodeStorageInGbs,
                memorySizeInGbs,
                shape,
                createdOn,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DBServerPatchingDetails"/>. </summary>
        /// <param name="estimatedPatchDuration"> Estimated Patch Duration. </param>
        /// <param name="patchingStatus"> Patching Status. </param>
        /// <param name="patchingEndedOn"> Time Patching Ended. </param>
        /// <param name="patchingStartedOn"> Time Patching Started. </param>
        /// <returns> A new <see cref="Models.DBServerPatchingDetails"/> instance for mocking. </returns>
        public static DBServerPatchingDetails DBServerPatchingDetails(int? estimatedPatchDuration = null, DBServerPatchingStatus? patchingStatus = null, DateTimeOffset? patchingEndedOn = null, DateTimeOffset? patchingStartedOn = null)
        {
            return new DBServerPatchingDetails(estimatedPatchDuration, patchingStatus, patchingEndedOn, patchingStartedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.CloudVmClusterDBNodeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.CloudVmClusterDBNodeData"/> instance for mocking. </returns>
        public static CloudVmClusterDBNodeData CloudVmClusterDBNodeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CloudVmClusterDBNodeProperties properties = null)
        {
            return new CloudVmClusterDBNodeData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudVmClusterDBNodeProperties"/>. </summary>
        /// <param name="ocid"> DbNode OCID. </param>
        /// <param name="additionalDetails"> Additional information about the planned maintenance. </param>
        /// <param name="backupIPId"> The OCID of the backup IP address associated with the database node. </param>
        /// <param name="backupVnic2Id"> The OCID of the second backup VNIC. </param>
        /// <param name="backupVnicId"> The OCID of the backup VNIC. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores enabled on the Db node. </param>
        /// <param name="dbNodeStorageSizeInGbs"> The allocated local node storage in GBs on the Db node. </param>
        /// <param name="dbServerId"> The OCID of the Exacc Db server associated with the database node. </param>
        /// <param name="dbSystemId"> The OCID of the DB system. </param>
        /// <param name="faultDomain"> The name of the Fault Domain the instance is contained in. </param>
        /// <param name="hostIPId"> The OCID of the host IP address associated with the database node. </param>
        /// <param name="hostname"> The host name for the database node. </param>
        /// <param name="lifecycleState"> The current state of the database node. </param>
        /// <param name="lifecycleDetails"> Lifecycle details of Db Node. </param>
        /// <param name="maintenanceType"> The type of database node maintenance. </param>
        /// <param name="memorySizeInGbs"> The allocated memory in GBs on the Db node. </param>
        /// <param name="softwareStorageSizeInGb"> The size (in GB) of the block storage volume allocation for the DB system. This attribute applies only for virtual machine DB systems. </param>
        /// <param name="timeCreated"> The date and time that the database node was created. </param>
        /// <param name="timeMaintenanceWindowEnd"> End date and time of maintenance window. </param>
        /// <param name="timeMaintenanceWindowStart"> Start date and time of maintenance window. </param>
        /// <param name="vnic2Id"> The OCID of the second VNIC. </param>
        /// <param name="vnicId"> The OCID of the VNIC. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <returns> A new <see cref="Models.CloudVmClusterDBNodeProperties"/> instance for mocking. </returns>
        public static CloudVmClusterDBNodeProperties CloudVmClusterDBNodeProperties(ResourceIdentifier ocid = null, string additionalDetails = null, ResourceIdentifier backupIPId = null, ResourceIdentifier backupVnic2Id = null, ResourceIdentifier backupVnicId = null, int? cpuCoreCount = null, int? dbNodeStorageSizeInGbs = null, ResourceIdentifier dbServerId = null, ResourceIdentifier dbSystemId = null, string faultDomain = null, ResourceIdentifier hostIPId = null, string hostname = null, DBNodeProvisioningState? lifecycleState = null, string lifecycleDetails = null, DBNodeMaintenanceType? maintenanceType = null, int? memorySizeInGbs = null, int? softwareStorageSizeInGb = null, DateTimeOffset? timeCreated = null, DateTimeOffset? timeMaintenanceWindowEnd = null, DateTimeOffset? timeMaintenanceWindowStart = null, ResourceIdentifier vnic2Id = null, ResourceIdentifier vnicId = null, OracleDatabaseResourceProvisioningState? provisioningState = null)
        {
            return new CloudVmClusterDBNodeProperties(
                ocid,
                additionalDetails,
                backupIPId,
                backupVnic2Id,
                backupVnicId,
                cpuCoreCount,
                dbNodeStorageSizeInGbs,
                dbServerId,
                dbSystemId,
                faultDomain,
                hostIPId,
                hostname,
                lifecycleState,
                lifecycleDetails,
                maintenanceType,
                memorySizeInGbs,
                softwareStorageSizeInGb,
                timeCreated,
                timeMaintenanceWindowEnd,
                timeMaintenanceWindowStart,
                vnic2Id,
                vnicId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateIPAddressResult"/>. </summary>
        /// <param name="displayName"> PrivateIpAddresses displayName. </param>
        /// <param name="hostnameLabel"> PrivateIpAddresses hostnameLabel. </param>
        /// <param name="ocid"> PrivateIpAddresses Id. </param>
        /// <param name="ipAddress"> PrivateIpAddresses ipAddress. </param>
        /// <param name="subnetId"> PrivateIpAddresses subnetId. </param>
        /// <returns> A new <see cref="Models.PrivateIPAddressResult"/> instance for mocking. </returns>
        public static PrivateIPAddressResult PrivateIPAddressResult(string displayName = null, string hostnameLabel = null, ResourceIdentifier ocid = null, string ipAddress = null, ResourceIdentifier subnetId = null)
        {
            return new PrivateIPAddressResult(
                displayName,
                hostnameLabel,
                ocid,
                ipAddress,
                subnetId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OracleDatabase.CloudVmClusterVirtualNetworkAddressData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The resource-specific properties for this resource. </param>
        /// <returns> A new <see cref="OracleDatabase.CloudVmClusterVirtualNetworkAddressData"/> instance for mocking. </returns>
        public static CloudVmClusterVirtualNetworkAddressData CloudVmClusterVirtualNetworkAddressData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CloudVmClusterVirtualNetworkAddressProperties properties = null)
        {
            return new CloudVmClusterVirtualNetworkAddressData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CloudVmClusterVirtualNetworkAddressProperties"/>. </summary>
        /// <param name="ipAddress"> Virtual network Address address. </param>
        /// <param name="vmOcid"> Virtual Machine OCID. </param>
        /// <param name="ocid"> Application VIP OCID. </param>
        /// <param name="domain"> Virtual network address fully qualified domain name. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state of the application virtual IP (VIP) address. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="lifecycleState"> virtual network address lifecycle state. </param>
        /// <param name="assignedOn"> The date and time when the create operation for the application virtual IP (VIP) address completed. </param>
        /// <returns> A new <see cref="Models.CloudVmClusterVirtualNetworkAddressProperties"/> instance for mocking. </returns>
        public static CloudVmClusterVirtualNetworkAddressProperties CloudVmClusterVirtualNetworkAddressProperties(string ipAddress = null, ResourceIdentifier vmOcid = null, ResourceIdentifier ocid = null, string domain = null, string lifecycleDetails = null, OracleDatabaseProvisioningState? provisioningState = null, VirtualNetworkAddressLifecycleState? lifecycleState = null, DateTimeOffset? assignedOn = null)
        {
            return new CloudVmClusterVirtualNetworkAddressProperties(
                ipAddress,
                vmOcid,
                ocid,
                domain,
                lifecycleDetails,
                provisioningState,
                lifecycleState,
                assignedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseCloneProperties"/>. </summary>
        /// <param name="adminPassword"> Admin password. </param>
        /// <param name="autonomousMaintenanceScheduleType"> The maintenance schedule type of the Autonomous Database Serverless. </param>
        /// <param name="characterSet"> The character set for the autonomous database. </param>
        /// <param name="computeCount"> The compute amount (CPUs) available to the database. </param>
        /// <param name="computeModel"> The compute model of the Autonomous Database. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores to be made available to the database. </param>
        /// <param name="customerContacts"> Customer Contacts. </param>
        /// <param name="dataStorageSizeInTbs"> The quantity of data in the database, in terabytes. </param>
        /// <param name="dataStorageSizeInGbs"> The size, in gigabytes, of the data volume that will be created and attached to the database. </param>
        /// <param name="dbVersion"> A valid Oracle Database version for Autonomous Database. </param>
        /// <param name="dbWorkload"> The Autonomous Database workload type. </param>
        /// <param name="displayName"> The user-friendly name for the Autonomous Database. </param>
        /// <param name="isAutoScalingEnabled"> Indicates if auto scaling is enabled for the Autonomous Database CPU core count. </param>
        /// <param name="isAutoScalingForStorageEnabled"> Indicates if auto scaling is enabled for the Autonomous Database storage. </param>
        /// <param name="peerDBIds"> The list of [OCIDs](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs. </param>
        /// <param name="peerDBId"> The database OCID of the Disaster Recovery peer database, which is located in a different region from the current peer database. </param>
        /// <param name="isLocalDataGuardEnabled"> Indicates whether the Autonomous Database has local or called in-region Data Guard enabled. </param>
        /// <param name="isRemoteDataGuardEnabled"> Indicates whether the Autonomous Database has Cross Region Data Guard enabled. </param>
        /// <param name="localDisasterRecoveryType"> Indicates the local disaster recovery (DR) type of the Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover. </param>
        /// <param name="localStandbyDB"> Local Autonomous Disaster Recovery standby database details. </param>
        /// <param name="failedDataRecoveryInSeconds"> Indicates the number of seconds of data loss for a Data Guard failover. </param>
        /// <param name="isMtlsConnectionRequired"> Specifies if the Autonomous Database requires mTLS connections. </param>
        /// <param name="isPreviewVersionWithServiceTermsAccepted"> Specifies if the Autonomous Database preview version is being provisioned. </param>
        /// <param name="licenseModel"> The Oracle license model that applies to the Oracle Autonomous Database. The default is LICENSE_INCLUDED. </param>
        /// <param name="ncharacterSet"> The character set for the Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="lifecycleState"> Views lifecycleState. </param>
        /// <param name="scheduledOperations"> The list of scheduled operations. </param>
        /// <param name="privateEndpointIP"> The private endpoint Ip address for the resource. </param>
        /// <param name="privateEndpointLabel"> The resource's private endpoint label. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="subnetId"> Client subnet. </param>
        /// <param name="vnetId"> VNET for network connectivity. </param>
        /// <param name="createdOn"> The date and time that the database was created. </param>
        /// <param name="maintenanceBeginOn"> The date and time when maintenance will begin. </param>
        /// <param name="maintenanceEndOn"> The date and time when maintenance will end. </param>
        /// <param name="actualUsedDataStorageSizeInTbs"> The current amount of storage in use for user and system data, in terabytes (TB). </param>
        /// <param name="allocatedStorageSizeInTbs"> The amount of storage currently allocated for the database tables and billed for, rounded up. </param>
        /// <param name="apexDetails"> Information about Oracle APEX Application Development. </param>
        /// <param name="availableUpgradeVersions"> List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty. </param>
        /// <param name="connectionStrings"> The connection string used to connect to the Autonomous Database. </param>
        /// <param name="connectionUrls"> The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. </param>
        /// <param name="dataSafeStatus"> Status of the Data Safe registration for this Autonomous Database. </param>
        /// <param name="databaseEdition"> The Oracle Database Edition that applies to the Autonomous databases. </param>
        /// <param name="autonomousDatabaseId"> Autonomous Database ID. </param>
        /// <param name="inMemoryAreaInGbs"> The area assigned to In-Memory tables in Autonomous Database. </param>
        /// <param name="nextLongTermBackupCreatedOn"> The date and time when the next long-term backup would be created. </param>
        /// <param name="longTermBackupSchedule"> Details for the long-term backup schedule. </param>
        /// <param name="isPreview"> Indicates if the Autonomous Database version is a preview version. </param>
        /// <param name="localAdgAutoFailoverMaxDataLossLimit"> Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard. </param>
        /// <param name="memoryPerOracleComputeUnitInGbs"> The amount of memory (in GBs) enabled per ECPU or OCPU. </param>
        /// <param name="openMode"> Indicates the Autonomous Database mode. </param>
        /// <param name="operationsInsightsStatus"> Status of Operations Insights for this Autonomous Database. </param>
        /// <param name="permissionLevel"> The Autonomous Database permission level. </param>
        /// <param name="privateEndpoint"> The private endpoint for the resource. </param>
        /// <param name="provisionableCpus"> An array of CPU values that an Autonomous Database can be scaled to. </param>
        /// <param name="role"> The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled. </param>
        /// <param name="serviceConsoleUri"> The URL of the Service Console for the Autonomous Database. </param>
        /// <param name="sqlWebDeveloperUri"> The SQL Web Developer URL for the Oracle Autonomous Database. </param>
        /// <param name="supportedRegionsToCloneTo"> The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database. </param>
        /// <param name="dataGuardRoleChangedOn"> The date and time the Autonomous Data Guard role was switched for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseDeletedOn"> The date and time the Always Free database will be automatically deleted because of inactivity. </param>
        /// <param name="timeLocalDataGuardEnabled"> The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database. </param>
        /// <param name="lastFailoverHappenedOn"> The timestamp of the last failover operation. </param>
        /// <param name="lastRefreshHappenedOn"> The date and time when last refresh happened. </param>
        /// <param name="lastRefreshPointTimestamp"> The refresh point timestamp (UTC). </param>
        /// <param name="lastSwitchoverHappenedOn"> The timestamp of the last switchover operation for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseStoppedOn"> The date and time the Always Free database will be stopped because of inactivity. </param>
        /// <param name="usedDataStorageSizeInGbs"> The storage space consumed by Autonomous Database in GBs. </param>
        /// <param name="usedDataStorageSizeInTbs"> The amount of storage that has been used, in terabytes. </param>
        /// <param name="ocid"> Database ocid. </param>
        /// <param name="backupRetentionPeriodInDays"> Retention period, in days, for long-term backups. </param>
        /// <param name="whitelistedIPs"> The client IP access control list (ACL). This is an array of CIDR notations and/or IP addresses. Values should be separate strings, separated by commas. Example: ['1.1.1.1','1.1.1.0/24','1.1.2.25']. </param>
        /// <param name="source"> The source of the database. </param>
        /// <param name="sourceId"> The Azure ID of the Autonomous Database that was cloned to create the current Autonomous Database. </param>
        /// <param name="cloneType"> The Autonomous Database clone type. </param>
        /// <param name="isReconnectCloneEnabled"> Indicates if the refreshable clone can be reconnected to its source database. </param>
        /// <param name="isRefreshableClone"> Indicates if the Autonomous Database is a refreshable clone. </param>
        /// <param name="refreshableModel"> The refresh mode of the clone. </param>
        /// <param name="refreshableStatus"> The refresh status of the clone. </param>
        /// <param name="reconnectCloneEnabledOn"> The time and date as an RFC3339 formatted string, e.g., 2022-01-01T12:00:00.000Z, to set the limit for a refreshable clone to be reconnected to its source database. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseCloneProperties"/> instance for mocking. </returns>
        public static AutonomousDatabaseCloneProperties AutonomousDatabaseCloneProperties(string adminPassword = null, AutonomousMaintenanceScheduleType? autonomousMaintenanceScheduleType = null, string characterSet = null, float? computeCount = null, AutonomousDatabaseComputeModel? computeModel = null, int? cpuCoreCount = null, IEnumerable<OracleCustomerContact> customerContacts = null, int? dataStorageSizeInTbs = null, int? dataStorageSizeInGbs = null, string dbVersion = null, AutonomousDatabaseWorkloadType? dbWorkload = null, string displayName = null, bool? isAutoScalingEnabled = null, bool? isAutoScalingForStorageEnabled = null, IEnumerable<string> peerDBIds = null, string peerDBId = null, bool? isLocalDataGuardEnabled = null, bool? isRemoteDataGuardEnabled = null, DisasterRecoveryType? localDisasterRecoveryType = null, AutonomousDatabaseStandbySummary localStandbyDB = null, int? failedDataRecoveryInSeconds = null, bool? isMtlsConnectionRequired = null, bool? isPreviewVersionWithServiceTermsAccepted = null, OracleLicenseModel? licenseModel = null, string ncharacterSet = null, string lifecycleDetails = null, OracleDatabaseProvisioningState? provisioningState = null, AutonomousDatabaseLifecycleState? lifecycleState = null, ScheduledOperationsType scheduledOperations = null, string privateEndpointIP = null, string privateEndpointLabel = null, Uri ociUri = null, ResourceIdentifier subnetId = null, ResourceIdentifier vnetId = null, DateTimeOffset? createdOn = null, DateTimeOffset? maintenanceBeginOn = null, DateTimeOffset? maintenanceEndOn = null, double? actualUsedDataStorageSizeInTbs = null, double? allocatedStorageSizeInTbs = null, OracleApexDetailsType apexDetails = null, IEnumerable<string> availableUpgradeVersions = null, AutonomousDatabaseConnectionStrings connectionStrings = null, AutonomousDatabaseConnectionUrls connectionUrls = null, DataSafeStatusType? dataSafeStatus = null, OracleDatabaseEditionType? databaseEdition = null, ResourceIdentifier autonomousDatabaseId = null, int? inMemoryAreaInGbs = null, DateTimeOffset? nextLongTermBackupCreatedOn = null, LongTermBackUpScheduleDetails longTermBackupSchedule = null, bool? isPreview = null, int? localAdgAutoFailoverMaxDataLossLimit = null, int? memoryPerOracleComputeUnitInGbs = null, AutonomousDatabaseModeType? openMode = null, OperationsInsightsStatusType? operationsInsightsStatus = null, AutonomousDatabasePermissionLevelType? permissionLevel = null, string privateEndpoint = null, IEnumerable<int> provisionableCpus = null, DataGuardRoleType? role = null, Uri serviceConsoleUri = null, Uri sqlWebDeveloperUri = null, IEnumerable<string> supportedRegionsToCloneTo = null, DateTimeOffset? dataGuardRoleChangedOn = null, DateTimeOffset? freeAutonomousDatabaseDeletedOn = null, string timeLocalDataGuardEnabled = null, DateTimeOffset? lastFailoverHappenedOn = null, DateTimeOffset? lastRefreshHappenedOn = null, DateTimeOffset? lastRefreshPointTimestamp = null, DateTimeOffset? lastSwitchoverHappenedOn = null, DateTimeOffset? freeAutonomousDatabaseStoppedOn = null, int? usedDataStorageSizeInGbs = null, int? usedDataStorageSizeInTbs = null, ResourceIdentifier ocid = null, int? backupRetentionPeriodInDays = null, IEnumerable<string> whitelistedIPs = null, AutonomousDatabaseSourceType? source = null, ResourceIdentifier sourceId = null, AutonomousDatabaseCloneType cloneType = default, bool? isReconnectCloneEnabled = null, bool? isRefreshableClone = null, RefreshableModelType? refreshableModel = null, RefreshableStatusType? refreshableStatus = null, DateTimeOffset? reconnectCloneEnabledOn = null)
        {
            customerContacts ??= new List<OracleCustomerContact>();
            peerDBIds ??= new List<string>();
            availableUpgradeVersions ??= new List<string>();
            provisionableCpus ??= new List<int>();
            supportedRegionsToCloneTo ??= new List<string>();
            whitelistedIPs ??= new List<string>();

            return new AutonomousDatabaseCloneProperties(
                adminPassword,
                OracleDataBaseType.Clone,
                autonomousMaintenanceScheduleType,
                characterSet,
                computeCount,
                computeModel,
                cpuCoreCount,
                customerContacts?.ToList(),
                dataStorageSizeInTbs,
                dataStorageSizeInGbs,
                dbVersion,
                dbWorkload,
                displayName,
                isAutoScalingEnabled,
                isAutoScalingForStorageEnabled,
                peerDBIds?.ToList(),
                peerDBId,
                isLocalDataGuardEnabled,
                isRemoteDataGuardEnabled,
                localDisasterRecoveryType,
                localStandbyDB,
                failedDataRecoveryInSeconds,
                isMtlsConnectionRequired,
                isPreviewVersionWithServiceTermsAccepted,
                licenseModel,
                ncharacterSet,
                lifecycleDetails,
                provisioningState,
                lifecycleState,
                scheduledOperations,
                privateEndpointIP,
                privateEndpointLabel,
                ociUri,
                subnetId,
                vnetId,
                createdOn,
                maintenanceBeginOn,
                maintenanceEndOn,
                actualUsedDataStorageSizeInTbs,
                allocatedStorageSizeInTbs,
                apexDetails,
                availableUpgradeVersions?.ToList(),
                connectionStrings,
                connectionUrls,
                dataSafeStatus,
                databaseEdition,
                autonomousDatabaseId,
                inMemoryAreaInGbs,
                nextLongTermBackupCreatedOn,
                longTermBackupSchedule,
                isPreview,
                localAdgAutoFailoverMaxDataLossLimit,
                memoryPerOracleComputeUnitInGbs,
                openMode,
                operationsInsightsStatus,
                permissionLevel,
                privateEndpoint,
                provisionableCpus?.ToList(),
                role,
                serviceConsoleUri,
                sqlWebDeveloperUri,
                supportedRegionsToCloneTo?.ToList(),
                dataGuardRoleChangedOn,
                freeAutonomousDatabaseDeletedOn,
                timeLocalDataGuardEnabled,
                lastFailoverHappenedOn,
                lastRefreshHappenedOn,
                lastRefreshPointTimestamp,
                lastSwitchoverHappenedOn,
                freeAutonomousDatabaseStoppedOn,
                usedDataStorageSizeInGbs,
                usedDataStorageSizeInTbs,
                ocid,
                backupRetentionPeriodInDays,
                whitelistedIPs?.ToList(),
                serializedAdditionalRawData: null,
                source,
                sourceId,
                cloneType,
                isReconnectCloneEnabled,
                isRefreshableClone,
                refreshableModel,
                refreshableStatus,
                reconnectCloneEnabledOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutonomousDatabaseProperties"/>. </summary>
        /// <param name="adminPassword"> Admin password. </param>
        /// <param name="autonomousMaintenanceScheduleType"> The maintenance schedule type of the Autonomous Database Serverless. </param>
        /// <param name="characterSet"> The character set for the autonomous database. </param>
        /// <param name="computeCount"> The compute amount (CPUs) available to the database. </param>
        /// <param name="computeModel"> The compute model of the Autonomous Database. </param>
        /// <param name="cpuCoreCount"> The number of CPU cores to be made available to the database. </param>
        /// <param name="customerContacts"> Customer Contacts. </param>
        /// <param name="dataStorageSizeInTbs"> The quantity of data in the database, in terabytes. </param>
        /// <param name="dataStorageSizeInGbs"> The size, in gigabytes, of the data volume that will be created and attached to the database. </param>
        /// <param name="dbVersion"> A valid Oracle Database version for Autonomous Database. </param>
        /// <param name="dbWorkload"> The Autonomous Database workload type. </param>
        /// <param name="displayName"> The user-friendly name for the Autonomous Database. </param>
        /// <param name="isAutoScalingEnabled"> Indicates if auto scaling is enabled for the Autonomous Database CPU core count. </param>
        /// <param name="isAutoScalingForStorageEnabled"> Indicates if auto scaling is enabled for the Autonomous Database storage. </param>
        /// <param name="peerDBIds"> The list of [OCIDs](https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of standby databases located in Autonomous Data Guard remote regions that are associated with the source database. Note that for Autonomous Database Serverless instances, standby databases located in the same region as the source primary database do not have OCIDs. </param>
        /// <param name="peerDBId"> The database OCID of the Disaster Recovery peer database, which is located in a different region from the current peer database. </param>
        /// <param name="isLocalDataGuardEnabled"> Indicates whether the Autonomous Database has local or called in-region Data Guard enabled. </param>
        /// <param name="isRemoteDataGuardEnabled"> Indicates whether the Autonomous Database has Cross Region Data Guard enabled. </param>
        /// <param name="localDisasterRecoveryType"> Indicates the local disaster recovery (DR) type of the Autonomous Database Serverless instance.Autonomous Data Guard (ADG) DR type provides business critical DR with a faster recovery time objective (RTO) during failover or switchover.Backup-based DR type provides lower cost DR with a slower RTO during failover or switchover. </param>
        /// <param name="localStandbyDB"> Local Autonomous Disaster Recovery standby database details. </param>
        /// <param name="failedDataRecoveryInSeconds"> Indicates the number of seconds of data loss for a Data Guard failover. </param>
        /// <param name="isMtlsConnectionRequired"> Specifies if the Autonomous Database requires mTLS connections. </param>
        /// <param name="isPreviewVersionWithServiceTermsAccepted"> Specifies if the Autonomous Database preview version is being provisioned. </param>
        /// <param name="licenseModel"> The Oracle license model that applies to the Oracle Autonomous Database. The default is LICENSE_INCLUDED. </param>
        /// <param name="ncharacterSet"> The character set for the Autonomous Database. </param>
        /// <param name="lifecycleDetails"> Additional information about the current lifecycle state. </param>
        /// <param name="provisioningState"> Azure resource provisioning state. </param>
        /// <param name="lifecycleState"> Views lifecycleState. </param>
        /// <param name="scheduledOperations"> The list of scheduled operations. </param>
        /// <param name="privateEndpointIP"> The private endpoint Ip address for the resource. </param>
        /// <param name="privateEndpointLabel"> The resource's private endpoint label. </param>
        /// <param name="ociUri"> HTTPS link to OCI resources exposed to Azure Customer via Azure Interface. </param>
        /// <param name="subnetId"> Client subnet. </param>
        /// <param name="vnetId"> VNET for network connectivity. </param>
        /// <param name="createdOn"> The date and time that the database was created. </param>
        /// <param name="maintenanceBeginOn"> The date and time when maintenance will begin. </param>
        /// <param name="maintenanceEndOn"> The date and time when maintenance will end. </param>
        /// <param name="actualUsedDataStorageSizeInTbs"> The current amount of storage in use for user and system data, in terabytes (TB). </param>
        /// <param name="allocatedStorageSizeInTbs"> The amount of storage currently allocated for the database tables and billed for, rounded up. </param>
        /// <param name="apexDetails"> Information about Oracle APEX Application Development. </param>
        /// <param name="availableUpgradeVersions"> List of Oracle Database versions available for a database upgrade. If there are no version upgrades available, this list is empty. </param>
        /// <param name="connectionStrings"> The connection string used to connect to the Autonomous Database. </param>
        /// <param name="connectionUrls"> The URLs for accessing Oracle Application Express (APEX) and SQL Developer Web with a browser from a Compute instance within your VCN or that has a direct connection to your VCN. </param>
        /// <param name="dataSafeStatus"> Status of the Data Safe registration for this Autonomous Database. </param>
        /// <param name="databaseEdition"> The Oracle Database Edition that applies to the Autonomous databases. </param>
        /// <param name="autonomousDatabaseId"> Autonomous Database ID. </param>
        /// <param name="inMemoryAreaInGbs"> The area assigned to In-Memory tables in Autonomous Database. </param>
        /// <param name="nextLongTermBackupCreatedOn"> The date and time when the next long-term backup would be created. </param>
        /// <param name="longTermBackupSchedule"> Details for the long-term backup schedule. </param>
        /// <param name="isPreview"> Indicates if the Autonomous Database version is a preview version. </param>
        /// <param name="localAdgAutoFailoverMaxDataLossLimit"> Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard. </param>
        /// <param name="memoryPerOracleComputeUnitInGbs"> The amount of memory (in GBs) enabled per ECPU or OCPU. </param>
        /// <param name="openMode"> Indicates the Autonomous Database mode. </param>
        /// <param name="operationsInsightsStatus"> Status of Operations Insights for this Autonomous Database. </param>
        /// <param name="permissionLevel"> The Autonomous Database permission level. </param>
        /// <param name="privateEndpoint"> The private endpoint for the resource. </param>
        /// <param name="provisionableCpus"> An array of CPU values that an Autonomous Database can be scaled to. </param>
        /// <param name="role"> The Data Guard role of the Autonomous Container Database or Autonomous Database, if Autonomous Data Guard is enabled. </param>
        /// <param name="serviceConsoleUri"> The URL of the Service Console for the Autonomous Database. </param>
        /// <param name="sqlWebDeveloperUri"> The SQL Web Developer URL for the Oracle Autonomous Database. </param>
        /// <param name="supportedRegionsToCloneTo"> The list of regions that support the creation of an Autonomous Database clone or an Autonomous Data Guard standby database. </param>
        /// <param name="dataGuardRoleChangedOn"> The date and time the Autonomous Data Guard role was switched for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseDeletedOn"> The date and time the Always Free database will be automatically deleted because of inactivity. </param>
        /// <param name="timeLocalDataGuardEnabled"> The date and time that Autonomous Data Guard was enabled for an Autonomous Database where the standby was provisioned in the same region as the primary database. </param>
        /// <param name="lastFailoverHappenedOn"> The timestamp of the last failover operation. </param>
        /// <param name="lastRefreshHappenedOn"> The date and time when last refresh happened. </param>
        /// <param name="lastRefreshPointTimestamp"> The refresh point timestamp (UTC). </param>
        /// <param name="lastSwitchoverHappenedOn"> The timestamp of the last switchover operation for the Autonomous Database. </param>
        /// <param name="freeAutonomousDatabaseStoppedOn"> The date and time the Always Free database will be stopped because of inactivity. </param>
        /// <param name="usedDataStorageSizeInGbs"> The storage space consumed by Autonomous Database in GBs. </param>
        /// <param name="usedDataStorageSizeInTbs"> The amount of storage that has been used, in terabytes. </param>
        /// <param name="ocid"> Database ocid. </param>
        /// <param name="backupRetentionPeriodInDays"> Retention period, in days, for long-term backups. </param>
        /// <param name="whitelistedIPs"> The client IP access control list (ACL). This is an array of CIDR notations and/or IP addresses. Values should be separate strings, separated by commas. Example: ['1.1.1.1','1.1.1.0/24','1.1.2.25']. </param>
        /// <returns> A new <see cref="Models.AutonomousDatabaseProperties"/> instance for mocking. </returns>
        public static AutonomousDatabaseProperties AutonomousDatabaseProperties(string adminPassword = null, AutonomousMaintenanceScheduleType? autonomousMaintenanceScheduleType = null, string characterSet = null, float? computeCount = null, AutonomousDatabaseComputeModel? computeModel = null, int? cpuCoreCount = null, IEnumerable<OracleCustomerContact> customerContacts = null, int? dataStorageSizeInTbs = null, int? dataStorageSizeInGbs = null, string dbVersion = null, AutonomousDatabaseWorkloadType? dbWorkload = null, string displayName = null, bool? isAutoScalingEnabled = null, bool? isAutoScalingForStorageEnabled = null, IEnumerable<string> peerDBIds = null, string peerDBId = null, bool? isLocalDataGuardEnabled = null, bool? isRemoteDataGuardEnabled = null, DisasterRecoveryType? localDisasterRecoveryType = null, AutonomousDatabaseStandbySummary localStandbyDB = null, int? failedDataRecoveryInSeconds = null, bool? isMtlsConnectionRequired = null, bool? isPreviewVersionWithServiceTermsAccepted = null, OracleLicenseModel? licenseModel = null, string ncharacterSet = null, string lifecycleDetails = null, OracleDatabaseProvisioningState? provisioningState = null, AutonomousDatabaseLifecycleState? lifecycleState = null, ScheduledOperationsType scheduledOperations = null, string privateEndpointIP = null, string privateEndpointLabel = null, Uri ociUri = null, ResourceIdentifier subnetId = null, ResourceIdentifier vnetId = null, DateTimeOffset? createdOn = null, DateTimeOffset? maintenanceBeginOn = null, DateTimeOffset? maintenanceEndOn = null, double? actualUsedDataStorageSizeInTbs = null, double? allocatedStorageSizeInTbs = null, OracleApexDetailsType apexDetails = null, IEnumerable<string> availableUpgradeVersions = null, AutonomousDatabaseConnectionStrings connectionStrings = null, AutonomousDatabaseConnectionUrls connectionUrls = null, DataSafeStatusType? dataSafeStatus = null, OracleDatabaseEditionType? databaseEdition = null, ResourceIdentifier autonomousDatabaseId = null, int? inMemoryAreaInGbs = null, DateTimeOffset? nextLongTermBackupCreatedOn = null, LongTermBackUpScheduleDetails longTermBackupSchedule = null, bool? isPreview = null, int? localAdgAutoFailoverMaxDataLossLimit = null, int? memoryPerOracleComputeUnitInGbs = null, AutonomousDatabaseModeType? openMode = null, OperationsInsightsStatusType? operationsInsightsStatus = null, AutonomousDatabasePermissionLevelType? permissionLevel = null, string privateEndpoint = null, IEnumerable<int> provisionableCpus = null, DataGuardRoleType? role = null, Uri serviceConsoleUri = null, Uri sqlWebDeveloperUri = null, IEnumerable<string> supportedRegionsToCloneTo = null, DateTimeOffset? dataGuardRoleChangedOn = null, DateTimeOffset? freeAutonomousDatabaseDeletedOn = null, string timeLocalDataGuardEnabled = null, DateTimeOffset? lastFailoverHappenedOn = null, DateTimeOffset? lastRefreshHappenedOn = null, DateTimeOffset? lastRefreshPointTimestamp = null, DateTimeOffset? lastSwitchoverHappenedOn = null, DateTimeOffset? freeAutonomousDatabaseStoppedOn = null, int? usedDataStorageSizeInGbs = null, int? usedDataStorageSizeInTbs = null, ResourceIdentifier ocid = null, int? backupRetentionPeriodInDays = null, IEnumerable<string> whitelistedIPs = null)
        {
            customerContacts ??= new List<OracleCustomerContact>();
            peerDBIds ??= new List<string>();
            availableUpgradeVersions ??= new List<string>();
            provisionableCpus ??= new List<int>();
            supportedRegionsToCloneTo ??= new List<string>();
            whitelistedIPs ??= new List<string>();

            return new AutonomousDatabaseProperties(
                adminPassword,
                OracleDataBaseType.Regular,
                autonomousMaintenanceScheduleType,
                characterSet,
                computeCount,
                computeModel,
                cpuCoreCount,
                customerContacts?.ToList(),
                dataStorageSizeInTbs,
                dataStorageSizeInGbs,
                dbVersion,
                dbWorkload,
                displayName,
                isAutoScalingEnabled,
                isAutoScalingForStorageEnabled,
                peerDBIds?.ToList(),
                peerDBId,
                isLocalDataGuardEnabled,
                isRemoteDataGuardEnabled,
                localDisasterRecoveryType,
                localStandbyDB,
                failedDataRecoveryInSeconds,
                isMtlsConnectionRequired,
                isPreviewVersionWithServiceTermsAccepted,
                licenseModel,
                ncharacterSet,
                lifecycleDetails,
                provisioningState,
                lifecycleState,
                scheduledOperations,
                privateEndpointIP,
                privateEndpointLabel,
                ociUri,
                subnetId,
                vnetId,
                createdOn,
                maintenanceBeginOn,
                maintenanceEndOn,
                actualUsedDataStorageSizeInTbs,
                allocatedStorageSizeInTbs,
                apexDetails,
                availableUpgradeVersions?.ToList(),
                connectionStrings,
                connectionUrls,
                dataSafeStatus,
                databaseEdition,
                autonomousDatabaseId,
                inMemoryAreaInGbs,
                nextLongTermBackupCreatedOn,
                longTermBackupSchedule,
                isPreview,
                localAdgAutoFailoverMaxDataLossLimit,
                memoryPerOracleComputeUnitInGbs,
                openMode,
                operationsInsightsStatus,
                permissionLevel,
                privateEndpoint,
                provisionableCpus?.ToList(),
                role,
                serviceConsoleUri,
                sqlWebDeveloperUri,
                supportedRegionsToCloneTo?.ToList(),
                dataGuardRoleChangedOn,
                freeAutonomousDatabaseDeletedOn,
                timeLocalDataGuardEnabled,
                lastFailoverHappenedOn,
                lastRefreshHappenedOn,
                lastRefreshPointTimestamp,
                lastSwitchoverHappenedOn,
                freeAutonomousDatabaseStoppedOn,
                usedDataStorageSizeInGbs,
                usedDataStorageSizeInTbs,
                ocid,
                backupRetentionPeriodInDays,
                whitelistedIPs?.ToList(),
                serializedAdditionalRawData: null);
        }
    }
}
