// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.OracleDatabase.Models;

namespace Azure.ResourceManager.OracleDatabase.Samples
{
    public partial class Sample_CloudVmClusterVirtualNetworkAddressResource
    {
        // Get Virtual Network Address
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetVirtualNetworkAddress()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/virtualNetworkAddresses_get.json
            // this example is just showing the usage of "VirtualNetworkAddresses_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudVmClusterVirtualNetworkAddressResource created on azure
            // for more information of creating CloudVmClusterVirtualNetworkAddressResource, please refer to the document of CloudVmClusterVirtualNetworkAddressResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string cloudvmclustername = "cluster1";
            string virtualnetworkaddressname = "hostname1";
            ResourceIdentifier cloudVmClusterVirtualNetworkAddressResourceId = CloudVmClusterVirtualNetworkAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudvmclustername, virtualnetworkaddressname);
            CloudVmClusterVirtualNetworkAddressResource cloudVmClusterVirtualNetworkAddress = client.GetCloudVmClusterVirtualNetworkAddressResource(cloudVmClusterVirtualNetworkAddressResourceId);

            // invoke the operation
            CloudVmClusterVirtualNetworkAddressResource result = await cloudVmClusterVirtualNetworkAddress.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CloudVmClusterVirtualNetworkAddressData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Virtual Network Address
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateVirtualNetworkAddress()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/virtualNetworkAddresses_create.json
            // this example is just showing the usage of "VirtualNetworkAddresses_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudVmClusterVirtualNetworkAddressResource created on azure
            // for more information of creating CloudVmClusterVirtualNetworkAddressResource, please refer to the document of CloudVmClusterVirtualNetworkAddressResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string cloudvmclustername = "cluster1";
            string virtualnetworkaddressname = "hostname1";
            ResourceIdentifier cloudVmClusterVirtualNetworkAddressResourceId = CloudVmClusterVirtualNetworkAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudvmclustername, virtualnetworkaddressname);
            CloudVmClusterVirtualNetworkAddressResource cloudVmClusterVirtualNetworkAddress = client.GetCloudVmClusterVirtualNetworkAddressResource(cloudVmClusterVirtualNetworkAddressResourceId);

            // invoke the operation
            CloudVmClusterVirtualNetworkAddressData data = new CloudVmClusterVirtualNetworkAddressData()
            {
                Properties = new CloudVmClusterVirtualNetworkAddressProperties()
                {
                    IPAddress = "192.168.0.1",
                    VmOcid = new ResourceIdentifier("ocid1..aaaa"),
                },
            };
            ArmOperation<CloudVmClusterVirtualNetworkAddressResource> lro = await cloudVmClusterVirtualNetworkAddress.UpdateAsync(WaitUntil.Completed, data);
            CloudVmClusterVirtualNetworkAddressResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CloudVmClusterVirtualNetworkAddressData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Virtual Network Address
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteVirtualNetworkAddress()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/virtualNetworkAddresses_delete.json
            // this example is just showing the usage of "VirtualNetworkAddresses_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudVmClusterVirtualNetworkAddressResource created on azure
            // for more information of creating CloudVmClusterVirtualNetworkAddressResource, please refer to the document of CloudVmClusterVirtualNetworkAddressResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string cloudvmclustername = "cluster1";
            string virtualnetworkaddressname = "hostname1";
            ResourceIdentifier cloudVmClusterVirtualNetworkAddressResourceId = CloudVmClusterVirtualNetworkAddressResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudvmclustername, virtualnetworkaddressname);
            CloudVmClusterVirtualNetworkAddressResource cloudVmClusterVirtualNetworkAddress = client.GetCloudVmClusterVirtualNetworkAddressResource(cloudVmClusterVirtualNetworkAddressResourceId);

            // invoke the operation
            await cloudVmClusterVirtualNetworkAddress.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
