// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.OracleDatabase.Models;

namespace Azure.ResourceManager.OracleDatabase.Samples
{
    public partial class Sample_AutonomousDatabaseBackupResource
    {
        // AutonomousDatabaseBackups_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AutonomousDatabaseBackupsGet()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_get.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            AutonomousDatabaseBackupResource result = await autonomousDatabaseBackup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutonomousDatabaseBackupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Autonomous Database Backup.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAutonomousDatabaseBackup()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_get.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            AutonomousDatabaseBackupResource result = await autonomousDatabaseBackup.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutonomousDatabaseBackupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AutonomousDatabaseBackups_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AutonomousDatabaseBackupsUpdate()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_patch.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            AutonomousDatabaseBackupPatch patch = new AutonomousDatabaseBackupPatch();
            ArmOperation<AutonomousDatabaseBackupResource> lro = await autonomousDatabaseBackup.UpdateAsync(WaitUntil.Completed, patch);
            AutonomousDatabaseBackupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutonomousDatabaseBackupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Patch Autonomous Database Backup.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchAutonomousDatabaseBackup()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_patch.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            AutonomousDatabaseBackupPatch patch = new AutonomousDatabaseBackupPatch();
            ArmOperation<AutonomousDatabaseBackupResource> lro = await autonomousDatabaseBackup.UpdateAsync(WaitUntil.Completed, patch);
            AutonomousDatabaseBackupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutonomousDatabaseBackupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AutonomousDatabaseBackups_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_AutonomousDatabaseBackupsDelete()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_delete.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            await autonomousDatabaseBackup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Delete Autonomous Database Backup.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAutonomousDatabaseBackup()
        {
            // Generated from example definition: specification/oracle/resource-manager/Oracle.Database/stable/2023-09-01/examples/autonomousDatabaseBackup_delete.json
            // this example is just showing the usage of "AutonomousDatabaseBackups_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutonomousDatabaseBackupResource created on azure
            // for more information of creating AutonomousDatabaseBackupResource, please refer to the document of AutonomousDatabaseBackupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg000";
            string autonomousdatabasename = "databasedb1";
            string adbbackupid = "1711644130";
            ResourceIdentifier autonomousDatabaseBackupResourceId = AutonomousDatabaseBackupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, autonomousdatabasename, adbbackupid);
            AutonomousDatabaseBackupResource autonomousDatabaseBackup = client.GetAutonomousDatabaseBackupResource(autonomousDatabaseBackupResourceId);

            // invoke the operation
            await autonomousDatabaseBackup.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
