// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.OperationalInsights.Models;

namespace Azure.ResourceManager.OperationalInsights
{
    internal partial class QueriesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of QueriesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public QueriesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2019-09-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, long? top, bool? includeBody, string skipToken)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (includeBody != null)
            {
                uri.AppendQuery("includeBody", includeBody.Value, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateListRequest(string subscriptionId, string resourceGroupName, string queryPackName, long? top, bool? includeBody, string skipToken)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (includeBody != null)
            {
                uri.AppendQuery("includeBody", includeBody.Value, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a list of Queries defined within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryPackQueryListResult>> ListAsync(string subscriptionId, string resourceGroupName, string queryPackName, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));

            using var message = CreateListRequest(subscriptionId, resourceGroupName, queryPackName, top, includeBody, skipToken);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of Queries defined within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryPackQueryListResult> List(string subscriptionId, string resourceGroupName, string queryPackName, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));

            using var message = CreateListRequest(subscriptionId, resourceGroupName, queryPackName, top, includeBody, skipToken);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSearchRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top, bool? includeBody, string skipToken)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/search", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (includeBody != null)
            {
                uri.AppendQuery("includeBody", includeBody.Value, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            return uri;
        }

        internal HttpMessage CreateSearchRequest(string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top, bool? includeBody, string skipToken)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/search", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (top != null)
            {
                uri.AppendQuery("$top", top.Value, true);
            }
            if (includeBody != null)
            {
                uri.AppendQuery("includeBody", includeBody.Value, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skipToken", skipToken, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(querySearchProperties, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Search a list of Queries defined within a Log Analytics QueryPack according to given search properties. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="querySearchProperties"> Properties by which to search queries in the given Log Analytics QueryPack. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="querySearchProperties"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryPackQueryListResult>> SearchAsync(string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNull(querySearchProperties, nameof(querySearchProperties));

            using var message = CreateSearchRequest(subscriptionId, resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Search a list of Queries defined within a Log Analytics QueryPack according to given search properties. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="querySearchProperties"> Properties by which to search queries in the given Log Analytics QueryPack. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="querySearchProperties"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryPackQueryListResult> Search(string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNull(querySearchProperties, nameof(querySearchProperties));

            using var message = CreateSearchRequest(subscriptionId, resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, string id)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string queryPackName, string id)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a specific Log Analytics Query defined within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryData>> GetAsync(string subscriptionId, string resourceGroupName, string queryPackName, string id, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, queryPackName, id);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((LogAnalyticsQueryData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a specific Log Analytics Query defined within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryData> Get(string subscriptionId, string resourceGroupName, string queryPackName, string id, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, queryPackName, id);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((LogAnalyticsQueryData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreatePutRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreatePutRequest(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Adds or Updates a specific Query within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="data"> Properties that need to be specified to create a new query and add it to a Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/>, <paramref name="id"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryData>> PutAsync(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutRequest(subscriptionId, resourceGroupName, queryPackName, id, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Adds or Updates a specific Query within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="data"> Properties that need to be specified to create a new query and add it to a Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/>, <paramref name="id"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryData> Put(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutRequest(subscriptionId, resourceGroupName, queryPackName, id, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateRequest(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Adds or Updates a specific Query within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="data"> Properties that need to be specified to create a new query and add it to a Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/>, <paramref name="id"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryData>> UpdateAsync(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, queryPackName, id, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Adds or Updates a specific Query within a Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="data"> Properties that need to be specified to create a new query and add it to a Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/>, <paramref name="id"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryData> Update(string subscriptionId, string resourceGroupName, string queryPackName, string id, LogAnalyticsQueryData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, queryPackName, id, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryData.DeserializeLogAnalyticsQueryData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string queryPackName, string id)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string queryPackName, string id)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.OperationalInsights/queryPacks/", false);
            uri.AppendPath(queryPackName, true);
            uri.AppendPath("/queries/", false);
            uri.AppendPath(id, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes a specific Query defined within an Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string queryPackName, string id, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, queryPackName, id);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes a specific Query defined within an Log Analytics QueryPack. </summary>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="id"> The id of a specific query defined in the Log Analytics QueryPack. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="id"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string queryPackName, string id, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNullOrEmpty(id, nameof(id));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, queryPackName, id);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, long? top, bool? includeBody, string skipToken)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, long? top, bool? includeBody, string skipToken)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a list of Queries defined within a Log Analytics QueryPack. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryPackQueryListResult>> ListNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, resourceGroupName, queryPackName, top, includeBody, skipToken);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of Queries defined within a Log Analytics QueryPack. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryPackQueryListResult> ListNextPage(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, resourceGroupName, queryPackName, top, includeBody, skipToken);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateSearchNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top, bool? includeBody, string skipToken)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateSearchNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top, bool? includeBody, string skipToken)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Search a list of Queries defined within a Log Analytics QueryPack according to given search properties. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="querySearchProperties"> Properties by which to search queries in the given Log Analytics QueryPack. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="querySearchProperties"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<LogAnalyticsQueryPackQueryListResult>> SearchNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNull(querySearchProperties, nameof(querySearchProperties));

            using var message = CreateSearchNextPageRequest(nextLink, subscriptionId, resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Search a list of Queries defined within a Log Analytics QueryPack according to given search properties. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The ID of the target subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group. The name is case insensitive. </param>
        /// <param name="queryPackName"> The name of the Log Analytics QueryPack resource. </param>
        /// <param name="querySearchProperties"> Properties by which to search queries in the given Log Analytics QueryPack. </param>
        /// <param name="top"> Maximum items returned in page. </param>
        /// <param name="includeBody"> Flag indicating whether or not to return the body of each applicable query. If false, only return the query information. </param>
        /// <param name="skipToken"> Base64 encoded token used to fetch the next page of items. Default is null. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="queryPackName"/> or <paramref name="querySearchProperties"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="queryPackName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<LogAnalyticsQueryPackQueryListResult> SearchNextPage(string nextLink, string subscriptionId, string resourceGroupName, string queryPackName, LogAnalyticsQuerySearchProperties querySearchProperties, long? top = null, bool? includeBody = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(queryPackName, nameof(queryPackName));
            Argument.AssertNotNull(querySearchProperties, nameof(querySearchProperties));

            using var message = CreateSearchNextPageRequest(nextLink, subscriptionId, resourceGroupName, queryPackName, querySearchProperties, top, includeBody, skipToken);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LogAnalyticsQueryPackQueryListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LogAnalyticsQueryPackQueryListResult.DeserializeLogAnalyticsQueryPackQueryListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
