// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.OperationalInsights.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.OperationalInsights
{
    /// <summary>
    /// A Class representing an OperationalInsightsWorkspace along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="OperationalInsightsWorkspaceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetOperationalInsightsWorkspaceResource method.
    /// Otherwise you can get one from its parent resource <see cref="ResourceGroupResource"/> using the GetOperationalInsightsWorkspace method.
    /// </summary>
    public partial class OperationalInsightsWorkspaceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="OperationalInsightsWorkspaceResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _operationalInsightsWorkspaceWorkspacesClientDiagnostics;
        private readonly WorkspacesRestOperations _operationalInsightsWorkspaceWorkspacesRestClient;
        private readonly ClientDiagnostics _intelligencePacksClientDiagnostics;
        private readonly IntelligencePacksRestOperations _intelligencePacksRestClient;
        private readonly ClientDiagnostics _managementGroupsClientDiagnostics;
        private readonly ManagementGroupsRestOperations _managementGroupsRestClient;
        private readonly ClientDiagnostics _sharedKeysClientDiagnostics;
        private readonly SharedKeysRestOperations _sharedKeysRestClient;
        private readonly ClientDiagnostics _usagesClientDiagnostics;
        private readonly UsagesRestOperations _usagesRestClient;
        private readonly ClientDiagnostics _availableServiceTiersClientDiagnostics;
        private readonly AvailableServiceTiersRestOperations _availableServiceTiersRestClient;
        private readonly ClientDiagnostics _gatewaysClientDiagnostics;
        private readonly GatewaysRestOperations _gatewaysRestClient;
        private readonly ClientDiagnostics _schemaClientDiagnostics;
        private readonly SchemaRestOperations _schemaRestClient;
        private readonly ClientDiagnostics _workspacePurgeClientDiagnostics;
        private readonly WorkspacePurgeRestOperations _workspacePurgeRestClient;
        private readonly OperationalInsightsWorkspaceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.OperationalInsights/workspaces";

        /// <summary> Initializes a new instance of the <see cref="OperationalInsightsWorkspaceResource"/> class for mocking. </summary>
        protected OperationalInsightsWorkspaceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OperationalInsightsWorkspaceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal OperationalInsightsWorkspaceResource(ArmClient client, OperationalInsightsWorkspaceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="OperationalInsightsWorkspaceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal OperationalInsightsWorkspaceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _operationalInsightsWorkspaceWorkspacesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string operationalInsightsWorkspaceWorkspacesApiVersion);
            _operationalInsightsWorkspaceWorkspacesRestClient = new WorkspacesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, operationalInsightsWorkspaceWorkspacesApiVersion);
            _intelligencePacksClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _intelligencePacksRestClient = new IntelligencePacksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _managementGroupsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _managementGroupsRestClient = new ManagementGroupsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _sharedKeysClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _sharedKeysRestClient = new SharedKeysRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _usagesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _usagesRestClient = new UsagesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _availableServiceTiersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _availableServiceTiersRestClient = new AvailableServiceTiersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _gatewaysClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _gatewaysRestClient = new GatewaysRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _schemaClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _schemaRestClient = new SchemaRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
            _workspacePurgeClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.OperationalInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _workspacePurgeRestClient = new WorkspacePurgeRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual OperationalInsightsWorkspaceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of OperationalInsightsDataExportResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsDataExportResources and their operations over a OperationalInsightsDataExportResource. </returns>
        public virtual OperationalInsightsDataExportCollection GetOperationalInsightsDataExports()
        {
            return GetCachedClient(client => new OperationalInsightsDataExportCollection(client, Id));
        }

        /// <summary>
        /// Gets a data export instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataExports/{dataExportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataExports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsDataExportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataExportName"> The data export rule name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataExportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataExportName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsDataExportResource>> GetOperationalInsightsDataExportAsync(string dataExportName, CancellationToken cancellationToken = default)
        {
            return await GetOperationalInsightsDataExports().GetAsync(dataExportName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a data export instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataExports/{dataExportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataExports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsDataExportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataExportName"> The data export rule name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataExportName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataExportName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsDataExportResource> GetOperationalInsightsDataExport(string dataExportName, CancellationToken cancellationToken = default)
        {
            return GetOperationalInsightsDataExports().Get(dataExportName, cancellationToken);
        }

        /// <summary> Gets a collection of OperationalInsightsDataSourceResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsDataSourceResources and their operations over a OperationalInsightsDataSourceResource. </returns>
        public virtual OperationalInsightsDataSourceCollection GetOperationalInsightsDataSources()
        {
            return GetCachedClient(client => new OperationalInsightsDataSourceCollection(client, Id));
        }

        /// <summary>
        /// Gets a datasource instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataSources_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsDataSourceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataSourceName"> Name of the datasource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSourceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataSourceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsDataSourceResource>> GetOperationalInsightsDataSourceAsync(string dataSourceName, CancellationToken cancellationToken = default)
        {
            return await GetOperationalInsightsDataSources().GetAsync(dataSourceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a datasource instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataSources/{dataSourceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataSources_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsDataSourceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataSourceName"> Name of the datasource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSourceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dataSourceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsDataSourceResource> GetOperationalInsightsDataSource(string dataSourceName, CancellationToken cancellationToken = default)
        {
            return GetOperationalInsightsDataSources().Get(dataSourceName, cancellationToken);
        }

        /// <summary> Gets a collection of OperationalInsightsLinkedServiceResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsLinkedServiceResources and their operations over a OperationalInsightsLinkedServiceResource. </returns>
        public virtual OperationalInsightsLinkedServiceCollection GetOperationalInsightsLinkedServices()
        {
            return GetCachedClient(client => new OperationalInsightsLinkedServiceCollection(client, Id));
        }

        /// <summary>
        /// Gets a linked service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LinkedServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsLinkedServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="linkedServiceName"> Name of the linked service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkedServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="linkedServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsLinkedServiceResource>> GetOperationalInsightsLinkedServiceAsync(string linkedServiceName, CancellationToken cancellationToken = default)
        {
            return await GetOperationalInsightsLinkedServices().GetAsync(linkedServiceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a linked service instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LinkedServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsLinkedServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="linkedServiceName"> Name of the linked service. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkedServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="linkedServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsLinkedServiceResource> GetOperationalInsightsLinkedService(string linkedServiceName, CancellationToken cancellationToken = default)
        {
            return GetOperationalInsightsLinkedServices().Get(linkedServiceName, cancellationToken);
        }

        /// <summary> Gets a collection of OperationalInsightsLinkedStorageAccountsResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsLinkedStorageAccountsResources and their operations over a OperationalInsightsLinkedStorageAccountsResource. </returns>
        public virtual OperationalInsightsLinkedStorageAccountsCollection GetAllOperationalInsightsLinkedStorageAccounts()
        {
            return GetCachedClient(client => new OperationalInsightsLinkedStorageAccountsCollection(client, Id));
        }

        /// <summary>
        /// Gets all linked storage account of a specific data source type associated with the specified workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedStorageAccounts/{dataSourceType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LinkedStorageAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsLinkedStorageAccountsResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataSourceType"> Linked storage accounts type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsLinkedStorageAccountsResource>> GetOperationalInsightsLinkedStorageAccountsAsync(OperationalInsightsDataSourceType dataSourceType, CancellationToken cancellationToken = default)
        {
            return await GetAllOperationalInsightsLinkedStorageAccounts().GetAsync(dataSourceType, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets all linked storage account of a specific data source type associated with the specified workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedStorageAccounts/{dataSourceType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LinkedStorageAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsLinkedStorageAccountsResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataSourceType"> Linked storage accounts type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsLinkedStorageAccountsResource> GetOperationalInsightsLinkedStorageAccounts(OperationalInsightsDataSourceType dataSourceType, CancellationToken cancellationToken = default)
        {
            return GetAllOperationalInsightsLinkedStorageAccounts().Get(dataSourceType, cancellationToken);
        }

        /// <summary> Gets a collection of StorageInsightResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of StorageInsightResources and their operations over a StorageInsightResource. </returns>
        public virtual StorageInsightCollection GetStorageInsights()
        {
            return GetCachedClient(client => new StorageInsightCollection(client, Id));
        }

        /// <summary>
        /// Gets a storage insight instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageInsightConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageInsightResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageInsightName"> Name of the storageInsightsConfigs resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageInsightName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="storageInsightName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<StorageInsightResource>> GetStorageInsightAsync(string storageInsightName, CancellationToken cancellationToken = default)
        {
            return await GetStorageInsights().GetAsync(storageInsightName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a storage insight instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StorageInsightConfigs_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageInsightResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="storageInsightName"> Name of the storageInsightsConfigs resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="storageInsightName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="storageInsightName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<StorageInsightResource> GetStorageInsight(string storageInsightName, CancellationToken cancellationToken = default)
        {
            return GetStorageInsights().Get(storageInsightName, cancellationToken);
        }

        /// <summary> Gets a collection of OperationalInsightsSavedSearchResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsSavedSearchResources and their operations over a OperationalInsightsSavedSearchResource. </returns>
        public virtual OperationalInsightsSavedSearchCollection GetOperationalInsightsSavedSearches()
        {
            return GetCachedClient(client => new OperationalInsightsSavedSearchCollection(client, Id));
        }

        /// <summary>
        /// Gets the specified saved search for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavedSearches_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsSavedSearchResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savedSearchId"> The id of the saved search. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savedSearchId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savedSearchId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsSavedSearchResource>> GetOperationalInsightsSavedSearchAsync(string savedSearchId, CancellationToken cancellationToken = default)
        {
            return await GetOperationalInsightsSavedSearches().GetAsync(savedSearchId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the specified saved search for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/savedSearches/{savedSearchId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavedSearches_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsSavedSearchResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savedSearchId"> The id of the saved search. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savedSearchId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savedSearchId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsSavedSearchResource> GetOperationalInsightsSavedSearch(string savedSearchId, CancellationToken cancellationToken = default)
        {
            return GetOperationalInsightsSavedSearches().Get(savedSearchId, cancellationToken);
        }

        /// <summary> Gets a collection of OperationalInsightsTableResources in the OperationalInsightsWorkspace. </summary>
        /// <returns> An object representing collection of OperationalInsightsTableResources and their operations over a OperationalInsightsTableResource. </returns>
        public virtual OperationalInsightsTableCollection GetOperationalInsightsTables()
        {
            return GetCachedClient(client => new OperationalInsightsTableCollection(client, Id));
        }

        /// <summary>
        /// Gets a Log Analytics workspace table.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/tables/{tableName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Tables_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsTableResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tableName"> The name of the table. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tableName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="tableName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<OperationalInsightsTableResource>> GetOperationalInsightsTableAsync(string tableName, CancellationToken cancellationToken = default)
        {
            return await GetOperationalInsightsTables().GetAsync(tableName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a Log Analytics workspace table.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/tables/{tableName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Tables_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsTableResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tableName"> The name of the table. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tableName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="tableName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<OperationalInsightsTableResource> GetOperationalInsightsTable(string tableName, CancellationToken cancellationToken = default)
        {
            return GetOperationalInsightsTables().Get(tableName, cancellationToken);
        }

        /// <summary>
        /// Gets a workspace instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<OperationalInsightsWorkspaceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Get");
            scope.Start();
            try
            {
                var response = await _operationalInsightsWorkspaceWorkspacesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<OperationalInsightsWorkspaceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Get");
            scope.Start();
            try
            {
                var response = _operationalInsightsWorkspaceWorkspacesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace. To remove the workspace completely and release the name, use the force flag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="force"> Deletes the workspace without the recovery option. A workspace that was deleted with this flag cannot be recovered. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, bool? force = null, CancellationToken cancellationToken = default)
        {
            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Delete");
            scope.Start();
            try
            {
                var response = await _operationalInsightsWorkspaceWorkspacesRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, force, cancellationToken).ConfigureAwait(false);
                var operation = new OperationalInsightsArmOperation(_operationalInsightsWorkspaceWorkspacesClientDiagnostics, Pipeline, _operationalInsightsWorkspaceWorkspacesRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, force).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a workspace resource. To recover the workspace, create it again with the same name, in the same subscription, resource group and location. The name is kept for 14 days and cannot be used for another workspace. To remove the workspace completely and release the name, use the force flag.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="force"> Deletes the workspace without the recovery option. A workspace that was deleted with this flag cannot be recovered. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, bool? force = null, CancellationToken cancellationToken = default)
        {
            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Delete");
            scope.Start();
            try
            {
                var response = _operationalInsightsWorkspaceWorkspacesRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, force, cancellationToken);
                var operation = new OperationalInsightsArmOperation(_operationalInsightsWorkspaceWorkspacesClientDiagnostics, Pipeline, _operationalInsightsWorkspaceWorkspacesRestClient.CreateDeleteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, force).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> The parameters required to patch a workspace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspaceResource>> UpdateAsync(OperationalInsightsWorkspacePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Update");
            scope.Start();
            try
            {
                var response = await _operationalInsightsWorkspaceWorkspacesRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, patch, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="patch"> The parameters required to patch a workspace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspaceResource> Update(OperationalInsightsWorkspacePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Update");
            scope.Start();
            try
            {
                var response = _operationalInsightsWorkspaceWorkspacesRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, patch, cancellationToken);
                return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Disables an intelligence pack for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Disable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_Disable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="intelligencePackName"> The name of the intelligence pack to be disabled. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="intelligencePackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="intelligencePackName"/> is null. </exception>
        public virtual async Task<Response> DisableIntelligencePackAsync(string intelligencePackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(intelligencePackName, nameof(intelligencePackName));

            using var scope = _intelligencePacksClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.DisableIntelligencePack");
            scope.Start();
            try
            {
                var response = await _intelligencePacksRestClient.DisableAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, intelligencePackName, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Disables an intelligence pack for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Disable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_Disable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="intelligencePackName"> The name of the intelligence pack to be disabled. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="intelligencePackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="intelligencePackName"/> is null. </exception>
        public virtual Response DisableIntelligencePack(string intelligencePackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(intelligencePackName, nameof(intelligencePackName));

            using var scope = _intelligencePacksClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.DisableIntelligencePack");
            scope.Start();
            try
            {
                var response = _intelligencePacksRestClient.Disable(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, intelligencePackName, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Enables an intelligence pack for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Enable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_Enable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="intelligencePackName"> The name of the intelligence pack to be enabled. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="intelligencePackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="intelligencePackName"/> is null. </exception>
        public virtual async Task<Response> EnableIntelligencePackAsync(string intelligencePackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(intelligencePackName, nameof(intelligencePackName));

            using var scope = _intelligencePacksClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.EnableIntelligencePack");
            scope.Start();
            try
            {
                var response = await _intelligencePacksRestClient.EnableAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, intelligencePackName, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Enables an intelligence pack for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks/{intelligencePackName}/Enable</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_Enable</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="intelligencePackName"> The name of the intelligence pack to be enabled. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="intelligencePackName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="intelligencePackName"/> is null. </exception>
        public virtual Response EnableIntelligencePack(string intelligencePackName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(intelligencePackName, nameof(intelligencePackName));

            using var scope = _intelligencePacksClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.EnableIntelligencePack");
            scope.Start();
            try
            {
                var response = _intelligencePacksRestClient.Enable(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, intelligencePackName, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists all the intelligence packs possible and whether they are enabled or disabled for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OperationalInsightsIntelligencePack"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OperationalInsightsIntelligencePack> GetIntelligencePacksAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _intelligencePacksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => OperationalInsightsIntelligencePack.DeserializeOperationalInsightsIntelligencePack(e), _intelligencePacksClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetIntelligencePacks", "", null, cancellationToken);
        }

        /// <summary>
        /// Lists all the intelligence packs possible and whether they are enabled or disabled for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/intelligencePacks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntelligencePacks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OperationalInsightsIntelligencePack"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OperationalInsightsIntelligencePack> GetIntelligencePacks(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _intelligencePacksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => OperationalInsightsIntelligencePack.DeserializeOperationalInsightsIntelligencePack(e), _intelligencePacksClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetIntelligencePacks", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of management groups connected to a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/managementGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagementGroups_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OperationalInsightsManagementGroup"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OperationalInsightsManagementGroup> GetManagementGroupsAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managementGroupsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => OperationalInsightsManagementGroup.DeserializeOperationalInsightsManagementGroup(e), _managementGroupsClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetManagementGroups", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of management groups connected to a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/managementGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ManagementGroups_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OperationalInsightsManagementGroup"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OperationalInsightsManagementGroup> GetManagementGroups(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _managementGroupsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => OperationalInsightsManagementGroup.DeserializeOperationalInsightsManagementGroup(e), _managementGroupsClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetManagementGroups", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the shared keys for a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/sharedKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SharedKeys_GetSharedKeys</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<OperationalInsightsWorkspaceSharedKeys>> GetSharedKeysAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sharedKeysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.GetSharedKeys");
            scope.Start();
            try
            {
                var response = await _sharedKeysRestClient.GetSharedKeysAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the shared keys for a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/sharedKeys</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SharedKeys_GetSharedKeys</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<OperationalInsightsWorkspaceSharedKeys> GetSharedKeys(CancellationToken cancellationToken = default)
        {
            using var scope = _sharedKeysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.GetSharedKeys");
            scope.Start();
            try
            {
                var response = _sharedKeysRestClient.GetSharedKeys(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational Insights agents to the workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/regenerateSharedKey</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SharedKeys_Regenerate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<OperationalInsightsWorkspaceSharedKeys>> RegenerateSharedKeyAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sharedKeysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.RegenerateSharedKey");
            scope.Start();
            try
            {
                var response = await _sharedKeysRestClient.RegenerateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Regenerates the shared keys for a Log Analytics Workspace. These keys are used to connect Microsoft Operational Insights agents to the workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/regenerateSharedKey</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SharedKeys_Regenerate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<OperationalInsightsWorkspaceSharedKeys> RegenerateSharedKey(CancellationToken cancellationToken = default)
        {
            using var scope = _sharedKeysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.RegenerateSharedKey");
            scope.Start();
            try
            {
                var response = _sharedKeysRestClient.Regenerate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of usage metrics for a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/usages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Usages_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OperationalInsightsUsageMetric"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OperationalInsightsUsageMetric> GetUsagesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _usagesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => OperationalInsightsUsageMetric.DeserializeOperationalInsightsUsageMetric(e), _usagesClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetUsages", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of usage metrics for a workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/usages</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Usages_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OperationalInsightsUsageMetric"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OperationalInsightsUsageMetric> GetUsages(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _usagesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => OperationalInsightsUsageMetric.DeserializeOperationalInsightsUsageMetric(e), _usagesClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetUsages", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the available service tiers for the workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/availableServiceTiers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AvailableServiceTiers_ListByWorkspace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OperationalInsightsAvailableServiceTier"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OperationalInsightsAvailableServiceTier> GetAvailableServiceTiersAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _availableServiceTiersRestClient.CreateListByWorkspaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => OperationalInsightsAvailableServiceTier.DeserializeOperationalInsightsAvailableServiceTier(e), _availableServiceTiersClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetAvailableServiceTiers", "", null, cancellationToken);
        }

        /// <summary>
        /// Gets the available service tiers for the workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/availableServiceTiers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AvailableServiceTiers_ListByWorkspace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OperationalInsightsAvailableServiceTier"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OperationalInsightsAvailableServiceTier> GetAvailableServiceTiers(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _availableServiceTiersRestClient.CreateListByWorkspaceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => OperationalInsightsAvailableServiceTier.DeserializeOperationalInsightsAvailableServiceTier(e), _availableServiceTiersClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetAvailableServiceTiers", "", null, cancellationToken);
        }

        /// <summary>
        /// Delete a Log Analytics gateway.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/gateways/{gatewayId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Gateways_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="gatewayId"> The Log Analytics gateway Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> DeleteGatewayAsync(Guid gatewayId, CancellationToken cancellationToken = default)
        {
            using var scope = _gatewaysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.DeleteGateway");
            scope.Start();
            try
            {
                var response = await _gatewaysRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, gatewayId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete a Log Analytics gateway.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/gateways/{gatewayId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Gateways_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="gatewayId"> The Log Analytics gateway Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response DeleteGateway(Guid gatewayId, CancellationToken cancellationToken = default)
        {
            using var scope = _gatewaysClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.DeleteGateway");
            scope.Start();
            try
            {
                var response = _gatewaysRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, gatewayId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the schema for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/schema</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Schema_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OperationalInsightsSearchSchemaValue"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OperationalInsightsSearchSchemaValue> GetSchemasAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _schemaRestClient.CreateGetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => OperationalInsightsSearchSchemaValue.DeserializeOperationalInsightsSearchSchemaValue(e), _schemaClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetSchemas", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the schema for a given workspace.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/schema</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Schema_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OperationalInsightsSearchSchemaValue"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OperationalInsightsSearchSchemaValue> GetSchemas(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _schemaRestClient.CreateGetRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => OperationalInsightsSearchSchemaValue.DeserializeOperationalInsightsSearchSchemaValue(e), _schemaClientDiagnostics, Pipeline, "OperationalInsightsWorkspaceResource.GetSchemas", "value", null, cancellationToken);
        }

        /// <summary>
        /// Purges data in an Log Analytics workspace by a set of user-defined filters.
        ///
        /// In order to manage system resources, purge requests are throttled at 50 requests per hour. You should batch the execution of purge requests by sending a single command whose predicate includes all user identities that require purging. Use the in operator to specify multiple identities. You should run the query prior to using for a purge request to verify that the results are expected.
        /// Log Analytics only supports purge operations required for compliance with GDPR. The Log Analytics product team reserves the right to reject requests for purge operations that are not for the purpose of GDPR compliance. In the event of a dispute, please create a support ticket
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/purge</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspacePurge_Purge</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the body of a request to purge data in a single table of an Log Analytics Workspace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspacePurgeResult>> PurgeAsync(OperationalInsightsWorkspacePurgeContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _workspacePurgeClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Purge");
            scope.Start();
            try
            {
                var response = await _workspacePurgeRestClient.PurgeAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Purges data in an Log Analytics workspace by a set of user-defined filters.
        ///
        /// In order to manage system resources, purge requests are throttled at 50 requests per hour. You should batch the execution of purge requests by sending a single command whose predicate includes all user identities that require purging. Use the in operator to specify multiple identities. You should run the query prior to using for a purge request to verify that the results are expected.
        /// Log Analytics only supports purge operations required for compliance with GDPR. The Log Analytics product team reserves the right to reject requests for purge operations that are not for the purpose of GDPR compliance. In the event of a dispute, please create a support ticket
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/purge</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspacePurge_Purge</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the body of a request to purge data in a single table of an Log Analytics Workspace. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspacePurgeResult> Purge(OperationalInsightsWorkspacePurgeContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _workspacePurgeClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.Purge");
            scope.Start();
            try
            {
                var response = _workspacePurgeRestClient.Purge(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets status of an ongoing purge operation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/operations/{purgeId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspacePurge_GetPurgeStatus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="purgeId"> In a purge status request, this is the Id of the operation the status of which is returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="purgeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="purgeId"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspacePurgeStatusResult>> GetPurgeStatusAsync(string purgeId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(purgeId, nameof(purgeId));

            using var scope = _workspacePurgeClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.GetPurgeStatus");
            scope.Start();
            try
            {
                var response = await _workspacePurgeRestClient.GetPurgeStatusAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, purgeId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets status of an ongoing purge operation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/operations/{purgeId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspacePurge_GetPurgeStatus</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="purgeId"> In a purge status request, this is the Id of the operation the status of which is returned. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="purgeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="purgeId"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspacePurgeStatusResult> GetPurgeStatus(string purgeId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(purgeId, nameof(purgeId));

            using var scope = _workspacePurgeClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.GetPurgeStatus");
            scope.Start();
            try
            {
                var response = _workspacePurgeRestClient.GetPurgeStatus(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, purgeId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspaceResource>> AddTagAsync(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.AddTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues[key] = value;
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _operationalInsightsWorkspaceWorkspacesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a tag to the current resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="value"> The value for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspaceResource> AddTag(string key, string value, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.AddTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues[key] = value;
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _operationalInsightsWorkspaceWorkspacesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags[key] = value;
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspaceResource>> SetTagsAsync(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.SetTags");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    await GetTagResource().DeleteAsync(WaitUntil.Completed, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _operationalInsightsWorkspaceWorkspacesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    patch.Tags.ReplaceWith(tags);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Replace the tags on the resource with the given set.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="tags"> The set of tags to use as replacement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="tags"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspaceResource> SetTags(IDictionary<string, string> tags, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(tags, nameof(tags));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.SetTags");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    GetTagResource().Delete(WaitUntil.Completed, cancellationToken: cancellationToken);
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.ReplaceWith(tags);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _operationalInsightsWorkspaceWorkspacesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    patch.Tags.ReplaceWith(tags);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual async Task<Response<OperationalInsightsWorkspaceResource>> RemoveTagAsync(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.RemoveTag");
            scope.Start();
            try
            {
                if (await CanUseTagResourceAsync(cancellationToken: cancellationToken).ConfigureAwait(false))
                {
                    var originalTags = await GetTagResource().GetAsync(cancellationToken).ConfigureAwait(false);
                    originalTags.Value.Data.TagValues.Remove(key);
                    await GetTagResource().CreateOrUpdateAsync(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken).ConfigureAwait(false);
                    var originalResponse = await _operationalInsightsWorkspaceWorkspacesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken).ConfigureAwait(false);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = (await GetAsync(cancellationToken: cancellationToken).ConfigureAwait(false)).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = await UpdateAsync(patch, cancellationToken: cancellationToken).ConfigureAwait(false);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes a tag by key from the resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Workspaces_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-10-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OperationalInsightsWorkspaceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="key"> The key for the tag. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> is null. </exception>
        public virtual Response<OperationalInsightsWorkspaceResource> RemoveTag(string key, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(key, nameof(key));

            using var scope = _operationalInsightsWorkspaceWorkspacesClientDiagnostics.CreateScope("OperationalInsightsWorkspaceResource.RemoveTag");
            scope.Start();
            try
            {
                if (CanUseTagResource(cancellationToken: cancellationToken))
                {
                    var originalTags = GetTagResource().Get(cancellationToken);
                    originalTags.Value.Data.TagValues.Remove(key);
                    GetTagResource().CreateOrUpdate(WaitUntil.Completed, originalTags.Value.Data, cancellationToken: cancellationToken);
                    var originalResponse = _operationalInsightsWorkspaceWorkspacesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, cancellationToken);
                    return Response.FromValue(new OperationalInsightsWorkspaceResource(Client, originalResponse.Value), originalResponse.GetRawResponse());
                }
                else
                {
                    var current = Get(cancellationToken: cancellationToken).Value.Data;
                    var patch = new OperationalInsightsWorkspacePatch();
                    foreach (var tag in current.Tags)
                    {
                        patch.Tags.Add(tag);
                    }
                    patch.Tags.Remove(key);
                    var result = Update(patch, cancellationToken: cancellationToken);
                    return result;
                }
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
