// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.OperationalInsights.Models;

namespace Azure.ResourceManager.OperationalInsights
{
    /// <summary>
    /// A class representing the OperationalInsightsTable data model.
    /// Workspace data table definition.
    /// </summary>
    public partial class OperationalInsightsTableData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableData"/>. </summary>
        public OperationalInsightsTableData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="retentionInDays"> The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention. </param>
        /// <param name="totalRetentionInDays"> The table total retention in days, between 4 and 2556. Setting this property to -1 will default to table retention. </param>
        /// <param name="archiveRetentionInDays"> The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays). </param>
        /// <param name="searchResults"> Parameters of the search job that initiated this table. </param>
        /// <param name="restoredLogs"> Parameters of the restore operation that initiated this table. </param>
        /// <param name="resultStatistics"> Search job execution statistics. </param>
        /// <param name="plan"> Instruct the system how to handle and charge the logs ingested to this table. </param>
        /// <param name="lastPlanModifiedDate"> The timestamp that table plan was last modified (UTC). </param>
        /// <param name="schema"> Table schema. </param>
        /// <param name="provisioningState"> Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded. </param>
        /// <param name="isRetentionInDaysAsDefault"> True - Value originates from workspace retention in days, False - Customer specific. </param>
        /// <param name="isTotalRetentionInDaysAsDefault"> True - Value originates from retention in days, False - Customer specific. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsTableData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, int? retentionInDays, int? totalRetentionInDays, int? archiveRetentionInDays, OperationalInsightsTableSearchResults searchResults, OperationalInsightsTableRestoredLogs restoredLogs, OperationalInsightsTableResultStatistics resultStatistics, OperationalInsightsTablePlan? plan, string lastPlanModifiedDate, OperationalInsightsSchema schema, OperationalInsightsTableProvisioningState? provisioningState, bool? isRetentionInDaysAsDefault, bool? isTotalRetentionInDaysAsDefault, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            RetentionInDays = retentionInDays;
            TotalRetentionInDays = totalRetentionInDays;
            ArchiveRetentionInDays = archiveRetentionInDays;
            SearchResults = searchResults;
            RestoredLogs = restoredLogs;
            ResultStatistics = resultStatistics;
            Plan = plan;
            LastPlanModifiedDate = lastPlanModifiedDate;
            Schema = schema;
            ProvisioningState = provisioningState;
            IsRetentionInDaysAsDefault = isRetentionInDaysAsDefault;
            IsTotalRetentionInDaysAsDefault = isTotalRetentionInDaysAsDefault;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention. </summary>
        [WirePath("properties.retentionInDays")]
        public int? RetentionInDays { get; set; }
        /// <summary> The table total retention in days, between 4 and 2556. Setting this property to -1 will default to table retention. </summary>
        [WirePath("properties.totalRetentionInDays")]
        public int? TotalRetentionInDays { get; set; }
        /// <summary> The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays). </summary>
        [WirePath("properties.archiveRetentionInDays")]
        public int? ArchiveRetentionInDays { get; }
        /// <summary> Parameters of the search job that initiated this table. </summary>
        [WirePath("properties.searchResults")]
        public OperationalInsightsTableSearchResults SearchResults { get; set; }
        /// <summary> Parameters of the restore operation that initiated this table. </summary>
        [WirePath("properties.restoredLogs")]
        public OperationalInsightsTableRestoredLogs RestoredLogs { get; set; }
        /// <summary> Search job execution statistics. </summary>
        [WirePath("properties.resultStatistics")]
        public OperationalInsightsTableResultStatistics ResultStatistics { get; }
        /// <summary> Instruct the system how to handle and charge the logs ingested to this table. </summary>
        [WirePath("properties.plan")]
        public OperationalInsightsTablePlan? Plan { get; set; }
        /// <summary> The timestamp that table plan was last modified (UTC). </summary>
        [WirePath("properties.lastPlanModifiedDate")]
        public string LastPlanModifiedDate { get; }
        /// <summary> Table schema. </summary>
        [WirePath("properties.schema")]
        public OperationalInsightsSchema Schema { get; set; }
        /// <summary> Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded. </summary>
        [WirePath("properties.provisioningState")]
        public OperationalInsightsTableProvisioningState? ProvisioningState { get; }
        /// <summary> True - Value originates from workspace retention in days, False - Customer specific. </summary>
        [WirePath("properties.retentionInDaysAsDefault")]
        public bool? IsRetentionInDaysAsDefault { get; }
        /// <summary> True - Value originates from retention in days, False - Customer specific. </summary>
        [WirePath("properties.totalRetentionInDaysAsDefault")]
        public bool? IsTotalRetentionInDaysAsDefault { get; }
    }
}
