// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.OperationalInsights.Models;

namespace Azure.ResourceManager.OperationalInsights
{
    public partial class OperationalInsightsTableData : IUtf8JsonSerializable, IJsonModel<OperationalInsightsTableData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OperationalInsightsTableData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OperationalInsightsTableData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsTableData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalInsightsTableData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(RetentionInDays))
            {
                writer.WritePropertyName("retentionInDays"u8);
                writer.WriteNumberValue(RetentionInDays.Value);
            }
            if (Optional.IsDefined(TotalRetentionInDays))
            {
                writer.WritePropertyName("totalRetentionInDays"u8);
                writer.WriteNumberValue(TotalRetentionInDays.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ArchiveRetentionInDays))
            {
                writer.WritePropertyName("archiveRetentionInDays"u8);
                writer.WriteNumberValue(ArchiveRetentionInDays.Value);
            }
            if (Optional.IsDefined(SearchResults))
            {
                writer.WritePropertyName("searchResults"u8);
                writer.WriteObjectValue(SearchResults, options);
            }
            if (Optional.IsDefined(RestoredLogs))
            {
                writer.WritePropertyName("restoredLogs"u8);
                writer.WriteObjectValue(RestoredLogs, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ResultStatistics))
            {
                writer.WritePropertyName("resultStatistics"u8);
                writer.WriteObjectValue(ResultStatistics, options);
            }
            if (Optional.IsDefined(Plan))
            {
                writer.WritePropertyName("plan"u8);
                writer.WriteStringValue(Plan.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LastPlanModifiedDate))
            {
                writer.WritePropertyName("lastPlanModifiedDate"u8);
                writer.WriteStringValue(LastPlanModifiedDate);
            }
            if (Optional.IsDefined(Schema))
            {
                writer.WritePropertyName("schema"u8);
                writer.WriteObjectValue(Schema, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(IsRetentionInDaysAsDefault))
            {
                writer.WritePropertyName("retentionInDaysAsDefault"u8);
                writer.WriteBooleanValue(IsRetentionInDaysAsDefault.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsTotalRetentionInDaysAsDefault))
            {
                writer.WritePropertyName("totalRetentionInDaysAsDefault"u8);
                writer.WriteBooleanValue(IsTotalRetentionInDaysAsDefault.Value);
            }
            writer.WriteEndObject();
        }

        OperationalInsightsTableData IJsonModel<OperationalInsightsTableData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsTableData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalInsightsTableData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOperationalInsightsTableData(document.RootElement, options);
        }

        internal static OperationalInsightsTableData DeserializeOperationalInsightsTableData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            int? retentionInDays = default;
            int? totalRetentionInDays = default;
            int? archiveRetentionInDays = default;
            OperationalInsightsTableSearchResults searchResults = default;
            OperationalInsightsTableRestoredLogs restoredLogs = default;
            OperationalInsightsTableResultStatistics resultStatistics = default;
            OperationalInsightsTablePlan? plan = default;
            string lastPlanModifiedDate = default;
            OperationalInsightsSchema schema = default;
            OperationalInsightsTableProvisioningState? provisioningState = default;
            bool? retentionInDaysAsDefault = default;
            bool? totalRetentionInDaysAsDefault = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("retentionInDays"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            retentionInDays = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("totalRetentionInDays"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalRetentionInDays = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("archiveRetentionInDays"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            archiveRetentionInDays = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("searchResults"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            searchResults = OperationalInsightsTableSearchResults.DeserializeOperationalInsightsTableSearchResults(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("restoredLogs"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            restoredLogs = OperationalInsightsTableRestoredLogs.DeserializeOperationalInsightsTableRestoredLogs(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("resultStatistics"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resultStatistics = OperationalInsightsTableResultStatistics.DeserializeOperationalInsightsTableResultStatistics(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("plan"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            plan = new OperationalInsightsTablePlan(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("lastPlanModifiedDate"u8))
                        {
                            lastPlanModifiedDate = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("schema"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            schema = OperationalInsightsSchema.DeserializeOperationalInsightsSchema(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new OperationalInsightsTableProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("retentionInDaysAsDefault"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            retentionInDaysAsDefault = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("totalRetentionInDaysAsDefault"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalRetentionInDaysAsDefault = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OperationalInsightsTableData(
                id,
                name,
                type,
                systemData,
                retentionInDays,
                totalRetentionInDays,
                archiveRetentionInDays,
                searchResults,
                restoredLogs,
                resultStatistics,
                plan,
                lastPlanModifiedDate,
                schema,
                provisioningState,
                retentionInDaysAsDefault,
                totalRetentionInDaysAsDefault,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RetentionInDays), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    retentionInDays: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RetentionInDays))
                {
                    builder.Append("    retentionInDays: ");
                    builder.AppendLine($"{RetentionInDays.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalRetentionInDays), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalRetentionInDays: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalRetentionInDays))
                {
                    builder.Append("    totalRetentionInDays: ");
                    builder.AppendLine($"{TotalRetentionInDays.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ArchiveRetentionInDays), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    archiveRetentionInDays: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ArchiveRetentionInDays))
                {
                    builder.Append("    archiveRetentionInDays: ");
                    builder.AppendLine($"{ArchiveRetentionInDays.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SearchResults), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    searchResults: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SearchResults))
                {
                    builder.Append("    searchResults: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SearchResults, options, 4, false, "    searchResults: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RestoredLogs), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    restoredLogs: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RestoredLogs))
                {
                    builder.Append("    restoredLogs: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RestoredLogs, options, 4, false, "    restoredLogs: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResultStatistics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resultStatistics: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResultStatistics))
                {
                    builder.Append("    resultStatistics: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ResultStatistics, options, 4, false, "    resultStatistics: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Plan), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    plan: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Plan))
                {
                    builder.Append("    plan: ");
                    builder.AppendLine($"'{Plan.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastPlanModifiedDate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastPlanModifiedDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastPlanModifiedDate))
                {
                    builder.Append("    lastPlanModifiedDate: ");
                    if (LastPlanModifiedDate.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LastPlanModifiedDate}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LastPlanModifiedDate}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Schema), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    schema: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Schema))
                {
                    builder.Append("    schema: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Schema, options, 4, false, "    schema: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsRetentionInDaysAsDefault), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    retentionInDaysAsDefault: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsRetentionInDaysAsDefault))
                {
                    builder.Append("    retentionInDaysAsDefault: ");
                    var boolValue = IsRetentionInDaysAsDefault.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsTotalRetentionInDaysAsDefault), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalRetentionInDaysAsDefault: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsTotalRetentionInDaysAsDefault))
                {
                    builder.Append("    totalRetentionInDaysAsDefault: ");
                    var boolValue = IsTotalRetentionInDaysAsDefault.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<OperationalInsightsTableData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsTableData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(OperationalInsightsTableData)} does not support writing '{options.Format}' format.");
            }
        }

        OperationalInsightsTableData IPersistableModel<OperationalInsightsTableData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsTableData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOperationalInsightsTableData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OperationalInsightsTableData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OperationalInsightsTableData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
