// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.OperationalInsights.Models;

namespace Azure.ResourceManager.OperationalInsights
{
    /// <summary>
    /// A class representing the OperationalInsightsLinkedStorageAccounts data model.
    /// Linked storage accounts top level resource container.
    /// </summary>
    public partial class OperationalInsightsLinkedStorageAccountsData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsLinkedStorageAccountsData"/>. </summary>
        public OperationalInsightsLinkedStorageAccountsData()
        {
            StorageAccountIds = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsLinkedStorageAccountsData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSourceType"> Linked storage accounts type. </param>
        /// <param name="storageAccountIds"> Linked storage accounts resources ids. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsLinkedStorageAccountsData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, OperationalInsightsDataSourceType? dataSourceType, IList<ResourceIdentifier> storageAccountIds, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DataSourceType = dataSourceType;
            StorageAccountIds = storageAccountIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Linked storage accounts type. </summary>
        [WirePath("properties.dataSourceType")]
        public OperationalInsightsDataSourceType? DataSourceType { get; }
        /// <summary> Linked storage accounts resources ids. </summary>
        [WirePath("properties.storageAccountIds")]
        public IList<ResourceIdentifier> StorageAccountIds { get; }
    }
}
