// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The state of the storage insight connection to the workspace. </summary>
    public readonly partial struct StorageInsightState : IEquatable<StorageInsightState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageInsightState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageInsightState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OKValue = "OK";
        private const string ErrorValue = "ERROR";

        /// <summary> OK. </summary>
        public static StorageInsightState OK { get; } = new StorageInsightState(OKValue);
        /// <summary> ERROR. </summary>
        public static StorageInsightState Error { get; } = new StorageInsightState(ErrorValue);
        /// <summary> Determines if two <see cref="StorageInsightState"/> values are the same. </summary>
        public static bool operator ==(StorageInsightState left, StorageInsightState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageInsightState"/> values are not the same. </summary>
        public static bool operator !=(StorageInsightState left, StorageInsightState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageInsightState"/>. </summary>
        public static implicit operator StorageInsightState(string value) => new StorageInsightState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageInsightState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageInsightState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
