// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The get schema operation response. </summary>
    internal partial class SearchGetSchemaResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchGetSchemaResponse"/>. </summary>
        internal SearchGetSchemaResponse()
        {
            Value = new ChangeTrackingList<OperationalInsightsSearchSchemaValue>();
        }

        /// <summary> Initializes a new instance of <see cref="SearchGetSchemaResponse"/>. </summary>
        /// <param name="metadata"> The metadata from search results. </param>
        /// <param name="value"> The array of result values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchGetSchemaResponse(SearchMetadata metadata, IReadOnlyList<OperationalInsightsSearchSchemaValue> value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Metadata = metadata;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The metadata from search results. </summary>
        [WirePath("metadata")]
        public SearchMetadata Metadata { get; }
        /// <summary> The array of result values. </summary>
        [WirePath("value")]
        public IReadOnlyList<OperationalInsightsSearchSchemaValue> Value { get; }
    }
}
