// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The name of the SKU. </summary>
    public readonly partial struct OperationalInsightsWorkspaceSkuName : IEquatable<OperationalInsightsWorkspaceSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspaceSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsWorkspaceSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FreeValue = "Free";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string PerNodeValue = "PerNode";
        private const string PerGB2018Value = "PerGB2018";
        private const string StandaloneValue = "Standalone";
        private const string CapacityReservationValue = "CapacityReservation";
        private const string LAClusterValue = "LACluster";

        /// <summary> Free. </summary>
        public static OperationalInsightsWorkspaceSkuName Free { get; } = new OperationalInsightsWorkspaceSkuName(FreeValue);
        /// <summary> Standard. </summary>
        public static OperationalInsightsWorkspaceSkuName Standard { get; } = new OperationalInsightsWorkspaceSkuName(StandardValue);
        /// <summary> Premium. </summary>
        public static OperationalInsightsWorkspaceSkuName Premium { get; } = new OperationalInsightsWorkspaceSkuName(PremiumValue);
        /// <summary> PerNode. </summary>
        public static OperationalInsightsWorkspaceSkuName PerNode { get; } = new OperationalInsightsWorkspaceSkuName(PerNodeValue);
        /// <summary> PerGB2018. </summary>
        public static OperationalInsightsWorkspaceSkuName PerGB2018 { get; } = new OperationalInsightsWorkspaceSkuName(PerGB2018Value);
        /// <summary> Standalone. </summary>
        public static OperationalInsightsWorkspaceSkuName Standalone { get; } = new OperationalInsightsWorkspaceSkuName(StandaloneValue);
        /// <summary> CapacityReservation. </summary>
        public static OperationalInsightsWorkspaceSkuName CapacityReservation { get; } = new OperationalInsightsWorkspaceSkuName(CapacityReservationValue);
        /// <summary> LACluster. </summary>
        public static OperationalInsightsWorkspaceSkuName LACluster { get; } = new OperationalInsightsWorkspaceSkuName(LAClusterValue);
        /// <summary> Determines if two <see cref="OperationalInsightsWorkspaceSkuName"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsWorkspaceSkuName left, OperationalInsightsWorkspaceSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsWorkspaceSkuName"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsWorkspaceSkuName left, OperationalInsightsWorkspaceSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsWorkspaceSkuName"/>. </summary>
        public static implicit operator OperationalInsightsWorkspaceSkuName(string value) => new OperationalInsightsWorkspaceSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsWorkspaceSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsWorkspaceSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
