// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The shared keys for a workspace. </summary>
    public partial class OperationalInsightsWorkspaceSharedKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspaceSharedKeys"/>. </summary>
        internal OperationalInsightsWorkspaceSharedKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspaceSharedKeys"/>. </summary>
        /// <param name="primarySharedKey"> The primary shared key of a workspace. </param>
        /// <param name="secondarySharedKey"> The secondary shared key of a workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsWorkspaceSharedKeys(string primarySharedKey, string secondarySharedKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimarySharedKey = primarySharedKey;
            SecondarySharedKey = secondarySharedKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The primary shared key of a workspace. </summary>
        [WirePath("primarySharedKey")]
        public string PrimarySharedKey { get; }
        /// <summary> The secondary shared key of a workspace. </summary>
        [WirePath("secondarySharedKey")]
        public string SecondarySharedKey { get; }
    }
}
