// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Status of the operation represented by the requested Id. </summary>
    public readonly partial struct OperationalInsightsWorkspacePurgeState : IEquatable<OperationalInsightsWorkspacePurgeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspacePurgeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsWorkspacePurgeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "pending";
        private const string CompletedValue = "completed";

        /// <summary> pending. </summary>
        public static OperationalInsightsWorkspacePurgeState Pending { get; } = new OperationalInsightsWorkspacePurgeState(PendingValue);
        /// <summary> completed. </summary>
        public static OperationalInsightsWorkspacePurgeState Completed { get; } = new OperationalInsightsWorkspacePurgeState(CompletedValue);
        /// <summary> Determines if two <see cref="OperationalInsightsWorkspacePurgeState"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsWorkspacePurgeState left, OperationalInsightsWorkspacePurgeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsWorkspacePurgeState"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsWorkspacePurgeState left, OperationalInsightsWorkspacePurgeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsWorkspacePurgeState"/>. </summary>
        public static implicit operator OperationalInsightsWorkspacePurgeState(string value) => new OperationalInsightsWorkspacePurgeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsWorkspacePurgeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsWorkspacePurgeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
