// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The daily volume cap for ingestion. </summary>
    public partial class OperationalInsightsWorkspaceCapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspaceCapping"/>. </summary>
        public OperationalInsightsWorkspaceCapping()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsWorkspaceCapping"/>. </summary>
        /// <param name="dailyQuotaInGB"> The workspace daily quota for ingestion. </param>
        /// <param name="quotaNextResetTime"> The time when the quota will be rest. </param>
        /// <param name="dataIngestionStatus"> The status of data ingestion for this workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsWorkspaceCapping(double? dailyQuotaInGB, string quotaNextResetTime, OperationalInsightsDataIngestionStatus? dataIngestionStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DailyQuotaInGB = dailyQuotaInGB;
            QuotaNextResetTime = quotaNextResetTime;
            DataIngestionStatus = dataIngestionStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The workspace daily quota for ingestion. </summary>
        [WirePath("dailyQuotaGb")]
        public double? DailyQuotaInGB { get; set; }
        /// <summary> The time when the quota will be rest. </summary>
        [WirePath("quotaNextResetTime")]
        public string QuotaNextResetTime { get; }
        /// <summary> The status of data ingestion for this workspace. </summary>
        [WirePath("dataIngestionStatus")]
        public OperationalInsightsDataIngestionStatus? DataIngestionStatus { get; }
    }
}
