// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    public partial class OperationalInsightsWorkspaceCapping : IUtf8JsonSerializable, IJsonModel<OperationalInsightsWorkspaceCapping>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OperationalInsightsWorkspaceCapping>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OperationalInsightsWorkspaceCapping>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsWorkspaceCapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalInsightsWorkspaceCapping)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DailyQuotaInGB))
            {
                writer.WritePropertyName("dailyQuotaGb"u8);
                writer.WriteNumberValue(DailyQuotaInGB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(QuotaNextResetTime))
            {
                writer.WritePropertyName("quotaNextResetTime"u8);
                writer.WriteStringValue(QuotaNextResetTime);
            }
            if (options.Format != "W" && Optional.IsDefined(DataIngestionStatus))
            {
                writer.WritePropertyName("dataIngestionStatus"u8);
                writer.WriteStringValue(DataIngestionStatus.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OperationalInsightsWorkspaceCapping IJsonModel<OperationalInsightsWorkspaceCapping>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsWorkspaceCapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OperationalInsightsWorkspaceCapping)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOperationalInsightsWorkspaceCapping(document.RootElement, options);
        }

        internal static OperationalInsightsWorkspaceCapping DeserializeOperationalInsightsWorkspaceCapping(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            double? dailyQuotaGb = default;
            string quotaNextResetTime = default;
            OperationalInsightsDataIngestionStatus? dataIngestionStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dailyQuotaGb"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dailyQuotaGb = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("quotaNextResetTime"u8))
                {
                    quotaNextResetTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataIngestionStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataIngestionStatus = new OperationalInsightsDataIngestionStatus(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OperationalInsightsWorkspaceCapping(dailyQuotaGb, quotaNextResetTime, dataIngestionStatus, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DailyQuotaInGB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dailyQuotaGb: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DailyQuotaInGB))
                {
                    builder.Append("  dailyQuotaGb: ");
                    builder.AppendLine($"'{DailyQuotaInGB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(QuotaNextResetTime), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  quotaNextResetTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(QuotaNextResetTime))
                {
                    builder.Append("  quotaNextResetTime: ");
                    if (QuotaNextResetTime.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{QuotaNextResetTime}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{QuotaNextResetTime}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataIngestionStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataIngestionStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataIngestionStatus))
                {
                    builder.Append("  dataIngestionStatus: ");
                    builder.AppendLine($"'{DataIngestionStatus.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<OperationalInsightsWorkspaceCapping>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsWorkspaceCapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(OperationalInsightsWorkspaceCapping)} does not support writing '{options.Format}' format.");
            }
        }

        OperationalInsightsWorkspaceCapping IPersistableModel<OperationalInsightsWorkspaceCapping>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OperationalInsightsWorkspaceCapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOperationalInsightsWorkspaceCapping(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OperationalInsightsWorkspaceCapping)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OperationalInsightsWorkspaceCapping>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
