// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Table's creator. </summary>
    public readonly partial struct OperationalInsightsTableType : IEquatable<OperationalInsightsTableType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsTableType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftValue = "Microsoft";
        private const string CustomLogValue = "CustomLog";
        private const string RestoredLogsValue = "RestoredLogs";
        private const string SearchResultsValue = "SearchResults";

        /// <summary> Standard data collected by Azure Monitor. </summary>
        public static OperationalInsightsTableType Microsoft { get; } = new OperationalInsightsTableType(MicrosoftValue);
        /// <summary> Custom log table. </summary>
        public static OperationalInsightsTableType CustomLog { get; } = new OperationalInsightsTableType(CustomLogValue);
        /// <summary> Restored data. </summary>
        public static OperationalInsightsTableType RestoredLogs { get; } = new OperationalInsightsTableType(RestoredLogsValue);
        /// <summary> Data collected by a search job. </summary>
        public static OperationalInsightsTableType SearchResults { get; } = new OperationalInsightsTableType(SearchResultsValue);
        /// <summary> Determines if two <see cref="OperationalInsightsTableType"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsTableType left, OperationalInsightsTableType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsTableType"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsTableType left, OperationalInsightsTableType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsTableType"/>. </summary>
        public static implicit operator OperationalInsightsTableType(string value) => new OperationalInsightsTableType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsTableType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsTableType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
