// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Parameters of the search job that initiated this table. </summary>
    public partial class OperationalInsightsTableSearchResults
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableSearchResults"/>. </summary>
        public OperationalInsightsTableSearchResults()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableSearchResults"/>. </summary>
        /// <param name="query"> Search job query. </param>
        /// <param name="description"> Search job Description. </param>
        /// <param name="limit"> Limit the search job to return up to specified number of rows. </param>
        /// <param name="startSearchOn"> The timestamp to start the search from (UTC). </param>
        /// <param name="endSearchOn"> The timestamp to end the search by (UTC). </param>
        /// <param name="sourceTable"> The table used in the search job. </param>
        /// <param name="azureAsyncOperationId"> Search results table async operation id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsTableSearchResults(string query, string description, int? limit, DateTimeOffset? startSearchOn, DateTimeOffset? endSearchOn, string sourceTable, Guid? azureAsyncOperationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Query = query;
            Description = description;
            Limit = limit;
            StartSearchOn = startSearchOn;
            EndSearchOn = endSearchOn;
            SourceTable = sourceTable;
            AzureAsyncOperationId = azureAsyncOperationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Search job query. </summary>
        [WirePath("query")]
        public string Query { get; set; }
        /// <summary> Search job Description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Limit the search job to return up to specified number of rows. </summary>
        [WirePath("limit")]
        public int? Limit { get; set; }
        /// <summary> The timestamp to start the search from (UTC). </summary>
        [WirePath("startSearchTime")]
        public DateTimeOffset? StartSearchOn { get; set; }
        /// <summary> The timestamp to end the search by (UTC). </summary>
        [WirePath("endSearchTime")]
        public DateTimeOffset? EndSearchOn { get; set; }
        /// <summary> The table used in the search job. </summary>
        [WirePath("sourceTable")]
        public string SourceTable { get; }
        /// <summary> Search results table async operation id. </summary>
        [WirePath("azureAsyncOperationId")]
        public Guid? AzureAsyncOperationId { get; }
    }
}
