// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded. </summary>
    public readonly partial struct OperationalInsightsTableProvisioningState : IEquatable<OperationalInsightsTableProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsTableProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpdatingValue = "Updating";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";

        /// <summary> Table schema is still being built and updated, table is currently locked for any changes till the procedure is done. </summary>
        public static OperationalInsightsTableProvisioningState Updating { get; } = new OperationalInsightsTableProvisioningState(UpdatingValue);
        /// <summary> Table schema is stable and without changes, table data is being updated. </summary>
        public static OperationalInsightsTableProvisioningState InProgress { get; } = new OperationalInsightsTableProvisioningState(InProgressValue);
        /// <summary> Table state is stable and without changes, table is unlocked and open for new updates. </summary>
        public static OperationalInsightsTableProvisioningState Succeeded { get; } = new OperationalInsightsTableProvisioningState(SucceededValue);
        /// <summary> Table state is deleting. </summary>
        public static OperationalInsightsTableProvisioningState Deleting { get; } = new OperationalInsightsTableProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="OperationalInsightsTableProvisioningState"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsTableProvisioningState left, OperationalInsightsTableProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsTableProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsTableProvisioningState left, OperationalInsightsTableProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsTableProvisioningState"/>. </summary>
        public static implicit operator OperationalInsightsTableProvisioningState(string value) => new OperationalInsightsTableProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsTableProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsTableProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
