// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Table's creator. </summary>
    public readonly partial struct OperationalInsightsTableCreator : IEquatable<OperationalInsightsTableCreator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsTableCreator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsTableCreator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftValue = "microsoft";
        private const string CustomerValue = "customer";

        /// <summary> Tables provisioned by the system, as collected via Diagnostic Settings, the Agents, or any other standard data collection means. </summary>
        public static OperationalInsightsTableCreator Microsoft { get; } = new OperationalInsightsTableCreator(MicrosoftValue);
        /// <summary> Tables created by the owner of the Workspace, and only found in this Workspace. </summary>
        public static OperationalInsightsTableCreator Customer { get; } = new OperationalInsightsTableCreator(CustomerValue);
        /// <summary> Determines if two <see cref="OperationalInsightsTableCreator"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsTableCreator left, OperationalInsightsTableCreator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsTableCreator"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsTableCreator left, OperationalInsightsTableCreator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsTableCreator"/>. </summary>
        public static implicit operator OperationalInsightsTableCreator(string value) => new OperationalInsightsTableCreator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsTableCreator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsTableCreator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
