// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Describes a storage account connection. </summary>
    public partial class OperationalInsightsStorageAccount
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsStorageAccount"/>. </summary>
        /// <param name="id"> The Azure Resource Manager ID of the storage account resource. </param>
        /// <param name="key"> The storage account key. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="key"/> is null. </exception>
        public OperationalInsightsStorageAccount(ResourceIdentifier id, string key)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(key, nameof(key));

            Id = id;
            Key = key;
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsStorageAccount"/>. </summary>
        /// <param name="id"> The Azure Resource Manager ID of the storage account resource. </param>
        /// <param name="key"> The storage account key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsStorageAccount(ResourceIdentifier id, string key, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Key = key;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsStorageAccount"/> for deserialization. </summary>
        internal OperationalInsightsStorageAccount()
        {
        }

        /// <summary> The Azure Resource Manager ID of the storage account resource. </summary>
        [WirePath("id")]
        public ResourceIdentifier Id { get; set; }
        /// <summary> The storage account key. </summary>
        [WirePath("key")]
        public string Key { get; set; }
    }
}
