// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The core summary of a search. </summary>
    internal partial class OperationalInsightsSearchCoreSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsSearchCoreSummary"/>. </summary>
        /// <param name="numberOfDocuments"> The number of documents of a core summary. </param>
        internal OperationalInsightsSearchCoreSummary(long numberOfDocuments)
        {
            NumberOfDocuments = numberOfDocuments;
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsSearchCoreSummary"/>. </summary>
        /// <param name="status"> The status of a core summary. </param>
        /// <param name="numberOfDocuments"> The number of documents of a core summary. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsSearchCoreSummary(string status, long numberOfDocuments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            NumberOfDocuments = numberOfDocuments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsSearchCoreSummary"/> for deserialization. </summary>
        internal OperationalInsightsSearchCoreSummary()
        {
        }

        /// <summary> The status of a core summary. </summary>
        [WirePath("status")]
        public string Status { get; }
        /// <summary> The number of documents of a core summary. </summary>
        [WirePath("numberOfDocuments")]
        public long NumberOfDocuments { get; }
    }
}
