// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The network access type for operating on the Log Analytics Workspace. By default it is Enabled. </summary>
    public readonly partial struct OperationalInsightsPublicNetworkAccessType : IEquatable<OperationalInsightsPublicNetworkAccessType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsPublicNetworkAccessType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsPublicNetworkAccessType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enables connectivity to Log Analytics through public DNS. </summary>
        public static OperationalInsightsPublicNetworkAccessType Enabled { get; } = new OperationalInsightsPublicNetworkAccessType(EnabledValue);
        /// <summary> Disables public connectivity to Log Analytics through public DNS. </summary>
        public static OperationalInsightsPublicNetworkAccessType Disabled { get; } = new OperationalInsightsPublicNetworkAccessType(DisabledValue);
        /// <summary> Determines if two <see cref="OperationalInsightsPublicNetworkAccessType"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsPublicNetworkAccessType left, OperationalInsightsPublicNetworkAccessType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsPublicNetworkAccessType"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsPublicNetworkAccessType left, OperationalInsightsPublicNetworkAccessType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsPublicNetworkAccessType"/>. </summary>
        public static implicit operator OperationalInsightsPublicNetworkAccessType(string value) => new OperationalInsightsPublicNetworkAccessType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsPublicNetworkAccessType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsPublicNetworkAccessType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
