// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The provisioning state of the linked service. </summary>
    public readonly partial struct OperationalInsightsLinkedServiceEntityStatus : IEquatable<OperationalInsightsLinkedServiceEntityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsLinkedServiceEntityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsLinkedServiceEntityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string DeletingValue = "Deleting";
        private const string ProvisioningAccountValue = "ProvisioningAccount";
        private const string UpdatingValue = "Updating";

        /// <summary> Succeeded. </summary>
        public static OperationalInsightsLinkedServiceEntityStatus Succeeded { get; } = new OperationalInsightsLinkedServiceEntityStatus(SucceededValue);
        /// <summary> Deleting. </summary>
        public static OperationalInsightsLinkedServiceEntityStatus Deleting { get; } = new OperationalInsightsLinkedServiceEntityStatus(DeletingValue);
        /// <summary> ProvisioningAccount. </summary>
        public static OperationalInsightsLinkedServiceEntityStatus ProvisioningAccount { get; } = new OperationalInsightsLinkedServiceEntityStatus(ProvisioningAccountValue);
        /// <summary> Updating. </summary>
        public static OperationalInsightsLinkedServiceEntityStatus Updating { get; } = new OperationalInsightsLinkedServiceEntityStatus(UpdatingValue);
        /// <summary> Determines if two <see cref="OperationalInsightsLinkedServiceEntityStatus"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsLinkedServiceEntityStatus left, OperationalInsightsLinkedServiceEntityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsLinkedServiceEntityStatus"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsLinkedServiceEntityStatus left, OperationalInsightsLinkedServiceEntityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsLinkedServiceEntityStatus"/>. </summary>
        public static implicit operator OperationalInsightsLinkedServiceEntityStatus(string value) => new OperationalInsightsLinkedServiceEntityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsLinkedServiceEntityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsLinkedServiceEntityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
