// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Intelligence Pack containing a string name and boolean indicating if it's enabled. </summary>
    public partial class OperationalInsightsIntelligencePack
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsIntelligencePack"/>. </summary>
        internal OperationalInsightsIntelligencePack()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsIntelligencePack"/>. </summary>
        /// <param name="name"> The name of the intelligence pack. </param>
        /// <param name="isEnabled"> The enabled boolean for the intelligence pack. </param>
        /// <param name="displayName"> The display name of the intelligence pack. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsIntelligencePack(string name, bool? isEnabled, string displayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            IsEnabled = isEnabled;
            DisplayName = displayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the intelligence pack. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The enabled boolean for the intelligence pack. </summary>
        [WirePath("enabled")]
        public bool? IsEnabled { get; }
        /// <summary> The display name of the intelligence pack. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
    }
}
