// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    internal static partial class OperationalInsightsDataSourceTypeExtensions
    {
        public static string ToSerialString(this OperationalInsightsDataSourceType value) => value switch
        {
            OperationalInsightsDataSourceType.CustomLogs => "CustomLogs",
            OperationalInsightsDataSourceType.AzureWatson => "AzureWatson",
            OperationalInsightsDataSourceType.Query => "Query",
            OperationalInsightsDataSourceType.Ingestion => "Ingestion",
            OperationalInsightsDataSourceType.Alerts => "Alerts",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown OperationalInsightsDataSourceType value.")
        };

        public static OperationalInsightsDataSourceType ToOperationalInsightsDataSourceType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "CustomLogs")) return OperationalInsightsDataSourceType.CustomLogs;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AzureWatson")) return OperationalInsightsDataSourceType.AzureWatson;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Query")) return OperationalInsightsDataSourceType.Query;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Ingestion")) return OperationalInsightsDataSourceType.Ingestion;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Alerts")) return OperationalInsightsDataSourceType.Alerts;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown OperationalInsightsDataSourceType value.");
        }
    }
}
