// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> The type of the destination resource. </summary>
    public readonly partial struct OperationalInsightsDataExportDestinationType : IEquatable<OperationalInsightsDataExportDestinationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsDataExportDestinationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsDataExportDestinationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StorageAccountValue = "StorageAccount";
        private const string EventHubValue = "EventHub";

        /// <summary> StorageAccount. </summary>
        public static OperationalInsightsDataExportDestinationType StorageAccount { get; } = new OperationalInsightsDataExportDestinationType(StorageAccountValue);
        /// <summary> EventHub. </summary>
        public static OperationalInsightsDataExportDestinationType EventHub { get; } = new OperationalInsightsDataExportDestinationType(EventHubValue);
        /// <summary> Determines if two <see cref="OperationalInsightsDataExportDestinationType"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsDataExportDestinationType left, OperationalInsightsDataExportDestinationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsDataExportDestinationType"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsDataExportDestinationType left, OperationalInsightsDataExportDestinationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsDataExportDestinationType"/>. </summary>
        public static implicit operator OperationalInsightsDataExportDestinationType(string value) => new OperationalInsightsDataExportDestinationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsDataExportDestinationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsDataExportDestinationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
