// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Column data type. </summary>
    public readonly partial struct OperationalInsightsColumnType : IEquatable<OperationalInsightsColumnType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsColumnType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsColumnType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "string";
        private const string IntValue = "int";
        private const string LongValue = "long";
        private const string RealValue = "real";
        private const string BooleanValue = "boolean";
        private const string DateTimeValue = "dateTime";
        private const string GuidValue = "guid";
        private const string DynamicValue = "dynamic";

        /// <summary> string. </summary>
        public static OperationalInsightsColumnType String { get; } = new OperationalInsightsColumnType(StringValue);
        /// <summary> int. </summary>
        public static OperationalInsightsColumnType Int { get; } = new OperationalInsightsColumnType(IntValue);
        /// <summary> long. </summary>
        public static OperationalInsightsColumnType Long { get; } = new OperationalInsightsColumnType(LongValue);
        /// <summary> real. </summary>
        public static OperationalInsightsColumnType Real { get; } = new OperationalInsightsColumnType(RealValue);
        /// <summary> boolean. </summary>
        public static OperationalInsightsColumnType Boolean { get; } = new OperationalInsightsColumnType(BooleanValue);
        /// <summary> dateTime. </summary>
        public static OperationalInsightsColumnType DateTime { get; } = new OperationalInsightsColumnType(DateTimeValue);
        /// <summary> guid. </summary>
        public static OperationalInsightsColumnType Guid { get; } = new OperationalInsightsColumnType(GuidValue);
        /// <summary> dynamic. </summary>
        public static OperationalInsightsColumnType Dynamic { get; } = new OperationalInsightsColumnType(DynamicValue);
        /// <summary> Determines if two <see cref="OperationalInsightsColumnType"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsColumnType left, OperationalInsightsColumnType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsColumnType"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsColumnType left, OperationalInsightsColumnType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsColumnType"/>. </summary>
        public static implicit operator OperationalInsightsColumnType(string value) => new OperationalInsightsColumnType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsColumnType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsColumnType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
