// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Column data type logical hint. </summary>
    public readonly partial struct OperationalInsightsColumnDataTypeHint : IEquatable<OperationalInsightsColumnDataTypeHint>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsColumnDataTypeHint"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsColumnDataTypeHint(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UriValue = "uri";
        private const string GuidValue = "guid";
        private const string ArmPathValue = "armPath";
        private const string IPValue = "ip";

        /// <summary> A string that matches the pattern of a URI, for example, scheme://username:password@host:1234/this/is/a/path?k1=v1&amp;k2=v2#fragment. </summary>
        public static OperationalInsightsColumnDataTypeHint Uri { get; } = new OperationalInsightsColumnDataTypeHint(UriValue);
        /// <summary> A standard 128-bit GUID following the standard shape, xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx. </summary>
        public static OperationalInsightsColumnDataTypeHint Guid { get; } = new OperationalInsightsColumnDataTypeHint(GuidValue);
        /// <summary> An Azure Resource Model (ARM) path: /subscriptions/{...}/resourceGroups/{...}/providers/Microsoft.{...}/{...}/{...}/{...}... </summary>
        public static OperationalInsightsColumnDataTypeHint ArmPath { get; } = new OperationalInsightsColumnDataTypeHint(ArmPathValue);
        /// <summary> A standard V4/V6 ip address following the standard shape, x.x.x.x/y:y:y:y:y:y:y:y. </summary>
        public static OperationalInsightsColumnDataTypeHint IP { get; } = new OperationalInsightsColumnDataTypeHint(IPValue);
        /// <summary> Determines if two <see cref="OperationalInsightsColumnDataTypeHint"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsColumnDataTypeHint left, OperationalInsightsColumnDataTypeHint right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsColumnDataTypeHint"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsColumnDataTypeHint left, OperationalInsightsColumnDataTypeHint right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsColumnDataTypeHint"/>. </summary>
        public static implicit operator OperationalInsightsColumnDataTypeHint(string value) => new OperationalInsightsColumnDataTypeHint(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsColumnDataTypeHint other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsColumnDataTypeHint other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
