// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Configures whether billing will be only on the cluster or each workspace will be billed by its proportional use. This does not change the overall billing, only how it will be distributed. Default value is 'Cluster'. </summary>
    public readonly partial struct OperationalInsightsBillingType : IEquatable<OperationalInsightsBillingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsBillingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationalInsightsBillingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterValue = "Cluster";
        private const string WorkspacesValue = "Workspaces";

        /// <summary> Cluster. </summary>
        public static OperationalInsightsBillingType Cluster { get; } = new OperationalInsightsBillingType(ClusterValue);
        /// <summary> Workspaces. </summary>
        public static OperationalInsightsBillingType Workspaces { get; } = new OperationalInsightsBillingType(WorkspacesValue);
        /// <summary> Determines if two <see cref="OperationalInsightsBillingType"/> values are the same. </summary>
        public static bool operator ==(OperationalInsightsBillingType left, OperationalInsightsBillingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationalInsightsBillingType"/> values are not the same. </summary>
        public static bool operator !=(OperationalInsightsBillingType left, OperationalInsightsBillingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationalInsightsBillingType"/>. </summary>
        public static implicit operator OperationalInsightsBillingType(string value) => new OperationalInsightsBillingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationalInsightsBillingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationalInsightsBillingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
