// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Service Tier details. </summary>
    public partial class OperationalInsightsAvailableServiceTier
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsAvailableServiceTier"/>. </summary>
        internal OperationalInsightsAvailableServiceTier()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsightsAvailableServiceTier"/>. </summary>
        /// <param name="serviceTier"> The name of the Service Tier. </param>
        /// <param name="isEnabled"> True if the Service Tier is enabled for the workspace. </param>
        /// <param name="minimumRetention"> The minimum retention for the Service Tier, in days. </param>
        /// <param name="maximumRetention"> The maximum retention for the Service Tier, in days. </param>
        /// <param name="defaultRetention"> The default retention for the Service Tier, in days. </param>
        /// <param name="capacityReservationLevel"> The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier. </param>
        /// <param name="lastSkuUpdatedOn"> Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OperationalInsightsAvailableServiceTier(OperationalInsightsSkuName? serviceTier, bool? isEnabled, long? minimumRetention, long? maximumRetention, long? defaultRetention, long? capacityReservationLevel, DateTimeOffset? lastSkuUpdatedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceTier = serviceTier;
            IsEnabled = isEnabled;
            MinimumRetention = minimumRetention;
            MaximumRetention = maximumRetention;
            DefaultRetention = defaultRetention;
            CapacityReservationLevel = capacityReservationLevel;
            LastSkuUpdatedOn = lastSkuUpdatedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the Service Tier. </summary>
        [WirePath("serviceTier")]
        public OperationalInsightsSkuName? ServiceTier { get; }
        /// <summary> True if the Service Tier is enabled for the workspace. </summary>
        [WirePath("enabled")]
        public bool? IsEnabled { get; }
        /// <summary> The minimum retention for the Service Tier, in days. </summary>
        [WirePath("minimumRetention")]
        public long? MinimumRetention { get; }
        /// <summary> The maximum retention for the Service Tier, in days. </summary>
        [WirePath("maximumRetention")]
        public long? MaximumRetention { get; }
        /// <summary> The default retention for the Service Tier, in days. </summary>
        [WirePath("defaultRetention")]
        public long? DefaultRetention { get; }
        /// <summary> The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier. </summary>
        [WirePath("capacityReservationLevel")]
        public long? CapacityReservationLevel { get; }
        /// <summary> Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier. </summary>
        [WirePath("lastSkuUpdate")]
        public DateTimeOffset? LastSkuUpdatedOn { get; }
    }
}
