// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OperationalInsights
{
    internal class OperationalInsightsWorkspaceOperationSource : IOperationSource<OperationalInsightsWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal OperationalInsightsWorkspaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        OperationalInsightsWorkspaceResource IOperationSource<OperationalInsightsWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OperationalInsightsWorkspaceData.DeserializeOperationalInsightsWorkspaceData(document.RootElement);
            return new OperationalInsightsWorkspaceResource(_client, data);
        }

        async ValueTask<OperationalInsightsWorkspaceResource> IOperationSource<OperationalInsightsWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OperationalInsightsWorkspaceData.DeserializeOperationalInsightsWorkspaceData(document.RootElement);
            return new OperationalInsightsWorkspaceResource(_client, data);
        }
    }
}
