// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OperationalInsights
{
    internal class OperationalInsightsLinkedServiceOperationSource : IOperationSource<OperationalInsightsLinkedServiceResource>
    {
        private readonly ArmClient _client;

        internal OperationalInsightsLinkedServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        OperationalInsightsLinkedServiceResource IOperationSource<OperationalInsightsLinkedServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OperationalInsightsLinkedServiceData.DeserializeOperationalInsightsLinkedServiceData(document.RootElement);
            return new OperationalInsightsLinkedServiceResource(_client, data);
        }

        async ValueTask<OperationalInsightsLinkedServiceResource> IOperationSource<OperationalInsightsLinkedServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OperationalInsightsLinkedServiceData.DeserializeOperationalInsightsLinkedServiceData(document.RootElement);
            return new OperationalInsightsLinkedServiceResource(_client, data);
        }
    }
}
