// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.OperationalInsights
{
    internal class OperationalInsightsClusterOperationSource : IOperationSource<OperationalInsightsClusterResource>
    {
        private readonly ArmClient _client;

        internal OperationalInsightsClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        OperationalInsightsClusterResource IOperationSource<OperationalInsightsClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = OperationalInsightsClusterData.DeserializeOperationalInsightsClusterData(document.RootElement);
            return new OperationalInsightsClusterResource(_client, data);
        }

        async ValueTask<OperationalInsightsClusterResource> IOperationSource<OperationalInsightsClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = OperationalInsightsClusterData.DeserializeOperationalInsightsClusterData(document.RootElement);
            return new OperationalInsightsClusterResource(_client, data);
        }
    }
}
