// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.OperationalInsights.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmOperationalInsightsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="OperationalInsights.LogAnalyticsQueryPackData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="queryPackId"> The unique ID of your application. This field cannot be changed. </param>
        /// <param name="createdOn"> Creation Date for the Log Analytics QueryPack, in ISO 8601 format. </param>
        /// <param name="modifiedOn"> Last modified date of the Log Analytics QueryPack, in ISO 8601 format. </param>
        /// <param name="provisioningState"> Current state of this QueryPack: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled, and Failed. </param>
        /// <returns> A new <see cref="OperationalInsights.LogAnalyticsQueryPackData"/> instance for mocking. </returns>
        public static LogAnalyticsQueryPackData LogAnalyticsQueryPackData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, Guid? queryPackId = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, string provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new LogAnalyticsQueryPackData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                queryPackId,
                createdOn,
                modifiedOn,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.LogAnalyticsQueryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="applicationId"> The unique ID of your application. This field cannot be changed. </param>
        /// <param name="displayName"> Unique display name for your query within the Query Pack. </param>
        /// <param name="createdOn"> Creation Date for the Log Analytics Query, in ISO 8601 format. </param>
        /// <param name="modifiedOn"> Last modified date of the Log Analytics Query, in ISO 8601 format. </param>
        /// <param name="author"> Object Id of user creating the query. </param>
        /// <param name="description"> Description of the query. </param>
        /// <param name="body"> Body of the query. </param>
        /// <param name="related"> The related metadata items for the function. </param>
        /// <param name="tags"> Tags associated with the query. </param>
        /// <param name="properties"> Additional properties that can be set for the query. </param>
        /// <returns> A new <see cref="OperationalInsights.LogAnalyticsQueryData"/> instance for mocking. </returns>
        public static LogAnalyticsQueryData LogAnalyticsQueryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? applicationId = null, string displayName = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, string author = null, string description = null, string body = null, LogAnalyticsQueryRelatedMetadata related = null, IDictionary<string, IList<string>> tags = null, BinaryData properties = null)
        {
            tags ??= new Dictionary<string, IList<string>>();

            return new LogAnalyticsQueryData(
                id,
                name,
                resourceType,
                systemData,
                applicationId,
                displayName,
                createdOn,
                modifiedOn,
                author,
                description,
                body,
                related,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsDataExportData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataExportId"> The data export rule ID. </param>
        /// <param name="tableNames"> An array of tables to export, for example: [“Heartbeat, SecurityEvent”]. </param>
        /// <param name="isEnabled"> Active when enabled. </param>
        /// <param name="createdOn"> The latest data export rule modification time. </param>
        /// <param name="lastModifiedOn"> Date and time when the export was last modified. </param>
        /// <param name="resourceId"> The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure. </param>
        /// <param name="destinationType"> The type of the destination resource. </param>
        /// <param name="eventHubName"> Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsDataExportData"/> instance for mocking. </returns>
        public static OperationalInsightsDataExportData OperationalInsightsDataExportData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataExportId = null, IEnumerable<string> tableNames = null, bool? isEnabled = null, DateTimeOffset? createdOn = null, DateTimeOffset? lastModifiedOn = null, ResourceIdentifier resourceId = null, OperationalInsightsDataExportDestinationType? destinationType = null, string eventHubName = null)
        {
            tableNames ??= new List<string>();

            return new OperationalInsightsDataExportData(
                id,
                name,
                resourceType,
                systemData,
                dataExportId,
                tableNames?.ToList(),
                isEnabled,
                createdOn,
                lastModifiedOn,
                resourceId,
                destinationType,
                eventHubName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsDataSourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The data source properties in raw json format, each kind of data source have it's own schema. </param>
        /// <param name="etag"> The ETag of the data source. </param>
        /// <param name="kind"> The kind of the DataSource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsDataSourceData"/> instance for mocking. </returns>
        public static OperationalInsightsDataSourceData OperationalInsightsDataSourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BinaryData properties = null, ETag? etag = null, OperationalInsightsDataSourceKind kind = default, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new OperationalInsightsDataSourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                etag,
                kind,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsIntelligencePack"/>. </summary>
        /// <param name="name"> The name of the intelligence pack. </param>
        /// <param name="isEnabled"> The enabled boolean for the intelligence pack. </param>
        /// <param name="displayName"> The display name of the intelligence pack. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsIntelligencePack"/> instance for mocking. </returns>
        public static OperationalInsightsIntelligencePack OperationalInsightsIntelligencePack(string name = null, bool? isEnabled = null, string displayName = null)
        {
            return new OperationalInsightsIntelligencePack(name, isEnabled, displayName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsLinkedServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="resourceId"> The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access. </param>
        /// <param name="writeAccessResourceId"> The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access. </param>
        /// <param name="provisioningState"> The provisioning state of the linked service. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsLinkedServiceData"/> instance for mocking. </returns>
        public static OperationalInsightsLinkedServiceData OperationalInsightsLinkedServiceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, ResourceIdentifier resourceId = null, ResourceIdentifier writeAccessResourceId = null, OperationalInsightsLinkedServiceEntityStatus? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new OperationalInsightsLinkedServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                resourceId,
                writeAccessResourceId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsLinkedStorageAccountsData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSourceType"> Linked storage accounts type. </param>
        /// <param name="storageAccountIds"> Linked storage accounts resources ids. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsLinkedStorageAccountsData"/> instance for mocking. </returns>
        public static OperationalInsightsLinkedStorageAccountsData OperationalInsightsLinkedStorageAccountsData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, OperationalInsightsDataSourceType? dataSourceType = null, IEnumerable<ResourceIdentifier> storageAccountIds = null)
        {
            storageAccountIds ??= new List<ResourceIdentifier>();

            return new OperationalInsightsLinkedStorageAccountsData(
                id,
                name,
                resourceType,
                systemData,
                dataSourceType,
                storageAccountIds?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsManagementGroup"/>. </summary>
        /// <param name="serverCount"> The number of servers connected to the management group. </param>
        /// <param name="isGateway"> Gets or sets a value indicating whether the management group is a gateway. </param>
        /// <param name="name"> The name of the management group. </param>
        /// <param name="id"> The unique ID of the management group. </param>
        /// <param name="createdOn"> The datetime that the management group was created. </param>
        /// <param name="dataReceivedOn"> The last datetime that the management group received data. </param>
        /// <param name="version"> The version of System Center that is managing the management group. </param>
        /// <param name="sku"> The SKU of System Center that is managing the management group. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsManagementGroup"/> instance for mocking. </returns>
        public static OperationalInsightsManagementGroup OperationalInsightsManagementGroup(int? serverCount = null, bool? isGateway = null, string name = null, string id = null, DateTimeOffset? createdOn = null, DateTimeOffset? dataReceivedOn = null, string version = null, string sku = null)
        {
            return new OperationalInsightsManagementGroup(
                serverCount,
                isGateway,
                name,
                id,
                createdOn,
                dataReceivedOn,
                version,
                sku,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspaceSharedKeys"/>. </summary>
        /// <param name="primarySharedKey"> The primary shared key of a workspace. </param>
        /// <param name="secondarySharedKey"> The secondary shared key of a workspace. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspaceSharedKeys"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspaceSharedKeys OperationalInsightsWorkspaceSharedKeys(string primarySharedKey = null, string secondarySharedKey = null)
        {
            return new OperationalInsightsWorkspaceSharedKeys(primarySharedKey, secondarySharedKey, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsUsageMetric"/>. </summary>
        /// <param name="name"> The name of the metric. </param>
        /// <param name="unit"> The units used for the metric. </param>
        /// <param name="currentValue"> The current value of the metric. </param>
        /// <param name="limit"> The quota limit for the metric. </param>
        /// <param name="nextResetOn"> The time that the metric's value will reset. </param>
        /// <param name="quotaPeriod"> The quota period that determines the length of time between value resets. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsUsageMetric"/> instance for mocking. </returns>
        public static OperationalInsightsUsageMetric OperationalInsightsUsageMetric(OperationalInsightsMetricName name = null, string unit = null, double? currentValue = null, double? limit = null, DateTimeOffset? nextResetOn = null, string quotaPeriod = null)
        {
            return new OperationalInsightsUsageMetric(
                name,
                unit,
                currentValue,
                limit,
                nextResetOn,
                quotaPeriod,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsMetricName"/>. </summary>
        /// <param name="value"> The system name of the metric. </param>
        /// <param name="localizedValue"> The localized name of the metric. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsMetricName"/> instance for mocking. </returns>
        public static OperationalInsightsMetricName OperationalInsightsMetricName(string value = null, string localizedValue = null)
        {
            return new OperationalInsightsMetricName(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.StorageInsightData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The ETag of the storage insight. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="containers"> The names of the blob containers that the workspace should read. </param>
        /// <param name="tables"> The names of the Azure tables that the workspace should read. </param>
        /// <param name="storageAccount"> The storage account connection details. </param>
        /// <param name="status"> The status of the storage insight. </param>
        /// <returns> A new <see cref="OperationalInsights.StorageInsightData"/> instance for mocking. </returns>
        public static StorageInsightData StorageInsightData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, IDictionary<string, string> tags = null, IEnumerable<string> containers = null, IEnumerable<string> tables = null, OperationalInsightsStorageAccount storageAccount = null, StorageInsightStatus status = null)
        {
            tags ??= new Dictionary<string, string>();
            containers ??= new List<string>();
            tables ??= new List<string>();

            return new StorageInsightData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                tags,
                containers?.ToList(),
                tables?.ToList(),
                storageAccount,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StorageInsightStatus"/>. </summary>
        /// <param name="state"> The state of the storage insight connection to the workspace. </param>
        /// <param name="description"> Description of the state of the storage insight. </param>
        /// <returns> A new <see cref="Models.StorageInsightStatus"/> instance for mocking. </returns>
        public static StorageInsightStatus StorageInsightStatus(StorageInsightState state = default, string description = null)
        {
            return new StorageInsightStatus(state, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsSavedSearchData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag. </param>
        /// <param name="category"> The category of the saved search. This helps the user to find a saved search faster. </param>
        /// <param name="displayName"> Saved search display name. </param>
        /// <param name="query"> The query expression for the saved search. </param>
        /// <param name="functionAlias"> The function alias if query serves as a function. </param>
        /// <param name="functionParameters"> The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions. </param>
        /// <param name="version"> The version number of the query language. The current version is 2 and is the default. </param>
        /// <param name="tags"> The tags attached to the saved search. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsSavedSearchData"/> instance for mocking. </returns>
        public static OperationalInsightsSavedSearchData OperationalInsightsSavedSearchData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string category = null, string displayName = null, string query = null, string functionAlias = null, string functionParameters = null, long? version = null, IEnumerable<OperationalInsightsTag> tags = null)
        {
            tags ??= new List<OperationalInsightsTag>();

            return new OperationalInsightsSavedSearchData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                category,
                displayName,
                query,
                functionAlias,
                functionParameters,
                version,
                tags?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsAvailableServiceTier"/>. </summary>
        /// <param name="serviceTier"> The name of the Service Tier. </param>
        /// <param name="isEnabled"> True if the Service Tier is enabled for the workspace. </param>
        /// <param name="minimumRetention"> The minimum retention for the Service Tier, in days. </param>
        /// <param name="maximumRetention"> The maximum retention for the Service Tier, in days. </param>
        /// <param name="defaultRetention"> The default retention for the Service Tier, in days. </param>
        /// <param name="capacityReservationLevel"> The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier. </param>
        /// <param name="lastSkuUpdatedOn"> Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsAvailableServiceTier"/> instance for mocking. </returns>
        public static OperationalInsightsAvailableServiceTier OperationalInsightsAvailableServiceTier(OperationalInsightsSkuName? serviceTier = null, bool? isEnabled = null, long? minimumRetention = null, long? maximumRetention = null, long? defaultRetention = null, long? capacityReservationLevel = null, DateTimeOffset? lastSkuUpdatedOn = null)
        {
            return new OperationalInsightsAvailableServiceTier(
                serviceTier,
                isEnabled,
                minimumRetention,
                maximumRetention,
                defaultRetention,
                capacityReservationLevel,
                lastSkuUpdatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsSearchSchemaValue"/>. </summary>
        /// <param name="name"> The name of the schema. </param>
        /// <param name="displayName"> The display name of the schema. </param>
        /// <param name="searchSchemaValueType"> The type. </param>
        /// <param name="indexed"> The boolean that indicates the field is searchable as free text. </param>
        /// <param name="stored"> The boolean that indicates whether or not the field is stored. </param>
        /// <param name="facet"> The boolean that indicates whether or not the field is a facet. </param>
        /// <param name="ownerType"> The array of workflows containing the field. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsSearchSchemaValue"/> instance for mocking. </returns>
        public static OperationalInsightsSearchSchemaValue OperationalInsightsSearchSchemaValue(string name = null, string displayName = null, string searchSchemaValueType = null, bool indexed = default, bool stored = default, bool facet = default, IEnumerable<string> ownerType = null)
        {
            ownerType ??= new List<string>();

            return new OperationalInsightsSearchSchemaValue(
                name,
                displayName,
                searchSchemaValueType,
                indexed,
                stored,
                facet,
                ownerType?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspacePurgeResult"/>. </summary>
        /// <param name="operationStringId"> Id to use when querying for status for a particular purge operation. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspacePurgeResult"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspacePurgeResult OperationalInsightsWorkspacePurgeResult(string operationStringId = null)
        {
            return new OperationalInsightsWorkspacePurgeResult(operationStringId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspacePurgeStatusResult"/>. </summary>
        /// <param name="status"> Status of the operation represented by the requested Id. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspacePurgeStatusResult"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspacePurgeStatusResult OperationalInsightsWorkspacePurgeStatusResult(OperationalInsightsWorkspacePurgeState status = default)
        {
            return new OperationalInsightsWorkspacePurgeStatusResult(status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="sku"> The sku properties. </param>
        /// <param name="clusterId"> The ID associated with the cluster. </param>
        /// <param name="provisioningState"> The provisioning state of the cluster. </param>
        /// <param name="isDoubleEncryptionEnabled"> Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default value is 'true'. </param>
        /// <param name="isAvailabilityZonesEnabled"> Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer support Availability Zones. This Property can not be modified after cluster creation. Default value is 'true' if region supports Availability Zones. </param>
        /// <param name="billingType"> The cluster's billing type. </param>
        /// <param name="keyVaultProperties"> The associated key properties. </param>
        /// <param name="lastModifiedOn"> The last time the cluster was updated. </param>
        /// <param name="createdOn"> The cluster creation time. </param>
        /// <param name="associatedWorkspaces"> The list of Log Analytics workspaces associated with the cluster. </param>
        /// <param name="capacityReservationProperties"> Additional properties for capacity reservation. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsClusterData"/> instance for mocking. </returns>
        public static OperationalInsightsClusterData OperationalInsightsClusterData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, OperationalInsightsClusterSku sku = null, Guid? clusterId = null, OperationalInsightsClusterEntityStatus? provisioningState = null, bool? isDoubleEncryptionEnabled = null, bool? isAvailabilityZonesEnabled = null, OperationalInsightsBillingType? billingType = null, OperationalInsightsKeyVaultProperties keyVaultProperties = null, DateTimeOffset? lastModifiedOn = null, DateTimeOffset? createdOn = null, IEnumerable<OperationalInsightsClusterAssociatedWorkspace> associatedWorkspaces = null, OperationalInsightsCapacityReservationProperties capacityReservationProperties = null)
        {
            tags ??= new Dictionary<string, string>();
            associatedWorkspaces ??= new List<OperationalInsightsClusterAssociatedWorkspace>();

            return new OperationalInsightsClusterData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                sku,
                clusterId,
                provisioningState,
                isDoubleEncryptionEnabled,
                isAvailabilityZonesEnabled,
                billingType,
                keyVaultProperties,
                lastModifiedOn,
                createdOn,
                associatedWorkspaces?.ToList(),
                capacityReservationProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsClusterAssociatedWorkspace"/>. </summary>
        /// <param name="workspaceId"> The id of the assigned workspace. </param>
        /// <param name="workspaceName"> The name id the assigned workspace. </param>
        /// <param name="resourceId"> The ResourceId id the assigned workspace. </param>
        /// <param name="associatedOn"> The time of workspace association. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsClusterAssociatedWorkspace"/> instance for mocking. </returns>
        public static OperationalInsightsClusterAssociatedWorkspace OperationalInsightsClusterAssociatedWorkspace(Guid? workspaceId = null, string workspaceName = null, ResourceIdentifier resourceId = null, DateTimeOffset? associatedOn = null)
        {
            return new OperationalInsightsClusterAssociatedWorkspace(workspaceId, workspaceName, resourceId, associatedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsCapacityReservationProperties"/>. </summary>
        /// <param name="lastSkuUpdatedOn"> The last time Sku was updated. </param>
        /// <param name="minCapacity"> Minimum CapacityReservation value in GB. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsCapacityReservationProperties"/> instance for mocking. </returns>
        public static OperationalInsightsCapacityReservationProperties OperationalInsightsCapacityReservationProperties(DateTimeOffset? lastSkuUpdatedOn = null, long? minCapacity = null)
        {
            return new OperationalInsightsCapacityReservationProperties(lastSkuUpdatedOn, minCapacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> The identity of the resource. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="etag"> The etag of the workspace. </param>
        /// <param name="provisioningState"> The provisioning state of the workspace. </param>
        /// <param name="customerId"> This is a read-only property. Represents the ID associated with the workspace. </param>
        /// <param name="sku"> The SKU of the workspace. </param>
        /// <param name="retentionInDays"> The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details. </param>
        /// <param name="workspaceCapping"> The daily volume cap for ingestion. </param>
        /// <param name="createdOn"> Workspace creation date. </param>
        /// <param name="modifiedOn"> Workspace modification date. </param>
        /// <param name="publicNetworkAccessForIngestion"> The network access type for accessing Log Analytics ingestion. </param>
        /// <param name="publicNetworkAccessForQuery"> The network access type for accessing Log Analytics query. </param>
        /// <param name="forceCmkForQuery"> Indicates whether customer managed storage is mandatory for query management. </param>
        /// <param name="privateLinkScopedResources"> List of linked private link scope resources. </param>
        /// <param name="features"> Workspace features. </param>
        /// <param name="defaultDataCollectionRuleResourceId"> The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsWorkspaceData"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspaceData OperationalInsightsWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ETag? etag = null, OperationalInsightsWorkspaceEntityStatus? provisioningState = null, Guid? customerId = null, OperationalInsightsWorkspaceSku sku = null, int? retentionInDays = null, OperationalInsightsWorkspaceCapping workspaceCapping = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, OperationalInsightsPublicNetworkAccessType? publicNetworkAccessForIngestion = null, OperationalInsightsPublicNetworkAccessType? publicNetworkAccessForQuery = null, bool? forceCmkForQuery = null, IEnumerable<OperationalInsightsPrivateLinkScopedResourceInfo> privateLinkScopedResources = null, OperationalInsightsWorkspaceFeatures features = null, ResourceIdentifier defaultDataCollectionRuleResourceId = null)
        {
            tags ??= new Dictionary<string, string>();
            privateLinkScopedResources ??= new List<OperationalInsightsPrivateLinkScopedResourceInfo>();

            return new OperationalInsightsWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                etag,
                provisioningState,
                customerId,
                sku,
                retentionInDays,
                workspaceCapping,
                createdOn,
                modifiedOn,
                publicNetworkAccessForIngestion,
                publicNetworkAccessForQuery,
                forceCmkForQuery,
                privateLinkScopedResources?.ToList(),
                features,
                defaultDataCollectionRuleResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspaceSku"/>. </summary>
        /// <param name="name"> The name of the SKU. </param>
        /// <param name="capacityReservationLevel"> The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected. </param>
        /// <param name="lastSkuUpdatedOn"> The last time when the sku was updated. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspaceSku"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspaceSku OperationalInsightsWorkspaceSku(OperationalInsightsWorkspaceSkuName name = default, OperationalInsightsWorkspaceCapacityReservationLevel? capacityReservationLevel = null, DateTimeOffset? lastSkuUpdatedOn = null)
        {
            return new OperationalInsightsWorkspaceSku(name, capacityReservationLevel, lastSkuUpdatedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspaceCapping"/>. </summary>
        /// <param name="dailyQuotaInGB"> The workspace daily quota for ingestion. </param>
        /// <param name="quotaNextResetTime"> The time when the quota will be rest. </param>
        /// <param name="dataIngestionStatus"> The status of data ingestion for this workspace. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspaceCapping"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspaceCapping OperationalInsightsWorkspaceCapping(double? dailyQuotaInGB = null, string quotaNextResetTime = null, OperationalInsightsDataIngestionStatus? dataIngestionStatus = null)
        {
            return new OperationalInsightsWorkspaceCapping(dailyQuotaInGB, quotaNextResetTime, dataIngestionStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsPrivateLinkScopedResourceInfo"/>. </summary>
        /// <param name="resourceId"> The full resource Id of the private link scope resource. </param>
        /// <param name="scopeId"> The private link scope unique Identifier. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsPrivateLinkScopedResourceInfo"/> instance for mocking. </returns>
        public static OperationalInsightsPrivateLinkScopedResourceInfo OperationalInsightsPrivateLinkScopedResourceInfo(ResourceIdentifier resourceId = null, string scopeId = null)
        {
            return new OperationalInsightsPrivateLinkScopedResourceInfo(resourceId, scopeId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsWorkspacePatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="identity"> The identity of the resource. Current supported identity types: None, SystemAssigned, UserAssigned. </param>
        /// <param name="tags"> Resource tags. Optional. </param>
        /// <param name="provisioningState"> The provisioning state of the workspace. </param>
        /// <param name="customerId"> This is a read-only property. Represents the ID associated with the workspace. </param>
        /// <param name="sku"> The SKU of the workspace. </param>
        /// <param name="retentionInDays"> The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details. </param>
        /// <param name="workspaceCapping"> The daily volume cap for ingestion. </param>
        /// <param name="createdOn"> Workspace creation date. </param>
        /// <param name="modifiedOn"> Workspace modification date. </param>
        /// <param name="publicNetworkAccessForIngestion"> The network access type for accessing Log Analytics ingestion. </param>
        /// <param name="publicNetworkAccessForQuery"> The network access type for accessing Log Analytics query. </param>
        /// <param name="forceCmkForQuery"> Indicates whether customer managed storage is mandatory for query management. </param>
        /// <param name="privateLinkScopedResources"> List of linked private link scope resources. </param>
        /// <param name="features"> Workspace features. </param>
        /// <param name="defaultDataCollectionRuleResourceId"> The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}. </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsWorkspacePatch"/> instance for mocking. </returns>
        public static OperationalInsightsWorkspacePatch OperationalInsightsWorkspacePatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ManagedServiceIdentity identity = null, IDictionary<string, string> tags = null, OperationalInsightsWorkspaceEntityStatus? provisioningState = null, Guid? customerId = null, OperationalInsightsWorkspaceSku sku = null, int? retentionInDays = null, OperationalInsightsWorkspaceCapping workspaceCapping = null, DateTimeOffset? createdOn = null, DateTimeOffset? modifiedOn = null, OperationalInsightsPublicNetworkAccessType? publicNetworkAccessForIngestion = null, OperationalInsightsPublicNetworkAccessType? publicNetworkAccessForQuery = null, bool? forceCmkForQuery = null, IEnumerable<OperationalInsightsPrivateLinkScopedResourceInfo> privateLinkScopedResources = null, OperationalInsightsWorkspaceFeatures features = null, ResourceIdentifier defaultDataCollectionRuleResourceId = null, ETag? etag = null)
        {
            tags ??= new Dictionary<string, string>();
            privateLinkScopedResources ??= new List<OperationalInsightsPrivateLinkScopedResourceInfo>();

            return new OperationalInsightsWorkspacePatch(
                id,
                name,
                resourceType,
                systemData,
                identity,
                tags,
                provisioningState,
                customerId,
                sku,
                retentionInDays,
                workspaceCapping,
                createdOn,
                modifiedOn,
                publicNetworkAccessForIngestion,
                publicNetworkAccessForQuery,
                forceCmkForQuery,
                privateLinkScopedResources?.ToList(),
                features,
                defaultDataCollectionRuleResourceId,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="OperationalInsights.OperationalInsightsTableData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="retentionInDays"> The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention. </param>
        /// <param name="totalRetentionInDays"> The table total retention in days, between 4 and 2556. Setting this property to -1 will default to table retention. </param>
        /// <param name="archiveRetentionInDays"> The table data archive retention in days. Calculated as (totalRetentionInDays-retentionInDays). </param>
        /// <param name="searchResults"> Parameters of the search job that initiated this table. </param>
        /// <param name="restoredLogs"> Parameters of the restore operation that initiated this table. </param>
        /// <param name="resultStatistics"> Search job execution statistics. </param>
        /// <param name="plan"> Instruct the system how to handle and charge the logs ingested to this table. </param>
        /// <param name="lastPlanModifiedDate"> The timestamp that table plan was last modified (UTC). </param>
        /// <param name="schema"> Table schema. </param>
        /// <param name="provisioningState"> Table's current provisioning state. If set to 'updating', indicates a resource lock due to ongoing operation, forbidding any update to the table until the ongoing operation is concluded. </param>
        /// <param name="isRetentionInDaysAsDefault"> True - Value originates from workspace retention in days, False - Customer specific. </param>
        /// <param name="isTotalRetentionInDaysAsDefault"> True - Value originates from retention in days, False - Customer specific. </param>
        /// <returns> A new <see cref="OperationalInsights.OperationalInsightsTableData"/> instance for mocking. </returns>
        public static OperationalInsightsTableData OperationalInsightsTableData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, int? retentionInDays = null, int? totalRetentionInDays = null, int? archiveRetentionInDays = null, OperationalInsightsTableSearchResults searchResults = null, OperationalInsightsTableRestoredLogs restoredLogs = null, OperationalInsightsTableResultStatistics resultStatistics = null, OperationalInsightsTablePlan? plan = null, string lastPlanModifiedDate = null, OperationalInsightsSchema schema = null, OperationalInsightsTableProvisioningState? provisioningState = null, bool? isRetentionInDaysAsDefault = null, bool? isTotalRetentionInDaysAsDefault = null)
        {
            return new OperationalInsightsTableData(
                id,
                name,
                resourceType,
                systemData,
                retentionInDays,
                totalRetentionInDays,
                archiveRetentionInDays,
                searchResults,
                restoredLogs,
                resultStatistics,
                plan,
                lastPlanModifiedDate,
                schema,
                provisioningState,
                isRetentionInDaysAsDefault,
                isTotalRetentionInDaysAsDefault,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsTableSearchResults"/>. </summary>
        /// <param name="query"> Search job query. </param>
        /// <param name="description"> Search job Description. </param>
        /// <param name="limit"> Limit the search job to return up to specified number of rows. </param>
        /// <param name="startSearchOn"> The timestamp to start the search from (UTC). </param>
        /// <param name="endSearchOn"> The timestamp to end the search by (UTC). </param>
        /// <param name="sourceTable"> The table used in the search job. </param>
        /// <param name="azureAsyncOperationId"> Search results table async operation id. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsTableSearchResults"/> instance for mocking. </returns>
        public static OperationalInsightsTableSearchResults OperationalInsightsTableSearchResults(string query = null, string description = null, int? limit = null, DateTimeOffset? startSearchOn = null, DateTimeOffset? endSearchOn = null, string sourceTable = null, Guid? azureAsyncOperationId = null)
        {
            return new OperationalInsightsTableSearchResults(
                query,
                description,
                limit,
                startSearchOn,
                endSearchOn,
                sourceTable,
                azureAsyncOperationId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsTableRestoredLogs"/>. </summary>
        /// <param name="startRestoreOn"> The timestamp to start the restore from (UTC). </param>
        /// <param name="endRestoreOn"> The timestamp to end the restore by (UTC). </param>
        /// <param name="sourceTable"> The table to restore data from. </param>
        /// <param name="azureAsyncOperationId"> Search results table async operation id. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsTableRestoredLogs"/> instance for mocking. </returns>
        public static OperationalInsightsTableRestoredLogs OperationalInsightsTableRestoredLogs(DateTimeOffset? startRestoreOn = null, DateTimeOffset? endRestoreOn = null, string sourceTable = null, Guid? azureAsyncOperationId = null)
        {
            return new OperationalInsightsTableRestoredLogs(startRestoreOn, endRestoreOn, sourceTable, azureAsyncOperationId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsTableResultStatistics"/>. </summary>
        /// <param name="progress"> Search job completion percentage. </param>
        /// <param name="ingestedRecords"> The number of rows that were returned by the search job. </param>
        /// <param name="scannedGB"> Search job: Amount of scanned data. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsTableResultStatistics"/> instance for mocking. </returns>
        public static OperationalInsightsTableResultStatistics OperationalInsightsTableResultStatistics(float? progress = null, int? ingestedRecords = null, float? scannedGB = null)
        {
            return new OperationalInsightsTableResultStatistics(progress, ingestedRecords, scannedGB, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsSchema"/>. </summary>
        /// <param name="name"> Table name. </param>
        /// <param name="displayName"> Table display name. </param>
        /// <param name="description"> Table description. </param>
        /// <param name="columns"> A list of table custom columns. </param>
        /// <param name="standardColumns"> A list of table standard columns. </param>
        /// <param name="categories"> Table category. </param>
        /// <param name="labels"> Table labels. </param>
        /// <param name="source"> Table's creator. </param>
        /// <param name="tableType"> Table's creator. </param>
        /// <param name="tableSubType"> The subtype describes what APIs can be used to interact with the table, and what features are available against it. </param>
        /// <param name="solutions"> List of solutions the table is affiliated with. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsSchema"/> instance for mocking. </returns>
        public static OperationalInsightsSchema OperationalInsightsSchema(string name = null, string displayName = null, string description = null, IEnumerable<OperationalInsightsColumn> columns = null, IEnumerable<OperationalInsightsColumn> standardColumns = null, IEnumerable<string> categories = null, IEnumerable<string> labels = null, OperationalInsightsTableCreator? source = null, OperationalInsightsTableType? tableType = null, OperationalInsightsTableSubType? tableSubType = null, IEnumerable<string> solutions = null)
        {
            columns ??= new List<OperationalInsightsColumn>();
            standardColumns ??= new List<OperationalInsightsColumn>();
            categories ??= new List<string>();
            labels ??= new List<string>();
            solutions ??= new List<string>();

            return new OperationalInsightsSchema(
                name,
                displayName,
                description,
                columns?.ToList(),
                standardColumns?.ToList(),
                categories?.ToList(),
                labels?.ToList(),
                source,
                tableType,
                tableSubType,
                solutions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OperationalInsightsColumn"/>. </summary>
        /// <param name="name"> Column name. </param>
        /// <param name="columnType"> Column data type. </param>
        /// <param name="dataTypeHint"> Column data type logical hint. </param>
        /// <param name="displayName"> Column display name. </param>
        /// <param name="description"> Column description. </param>
        /// <param name="isDefaultDisplay"> Is displayed by default. </param>
        /// <param name="isHidden"> Is column hidden. </param>
        /// <returns> A new <see cref="Models.OperationalInsightsColumn"/> instance for mocking. </returns>
        public static OperationalInsightsColumn OperationalInsightsColumn(string name = null, OperationalInsightsColumnType? columnType = null, OperationalInsightsColumnDataTypeHint? dataTypeHint = null, string displayName = null, string description = null, bool? isDefaultDisplay = null, bool? isHidden = null)
        {
            return new OperationalInsightsColumn(
                name,
                columnType,
                dataTypeHint,
                displayName,
                description,
                isDefaultDisplay,
                isHidden,
                serializedAdditionalRawData: null);
        }
    }
}
